/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.block.CustomUnbakedBlockStateModel;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.model.data.ModelData;
import org.cyclops.cyclopscore.client.model.DelegatingDynamicItemAndBlockModel;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.cyclopscore.helper.ModelHelpers;
import org.cyclops.evilcraft.block.BlockEntangledChalice;
import org.cyclops.evilcraft.block.BlockEntangledChaliceConfig;
import org.cyclops.evilcraft.blockentity.BlockEntityEntangledChalice;
import org.cyclops.evilcraft.item.ItemEntangledChalice;
import org.jetbrains.annotations.Nullable;

public class ModelEntangledChaliceBaked
extends DelegatingDynamicItemAndBlockModel {
    private static final Map<String, Integer> seeds = Maps.newHashMap();
    private final BlockStateModel chaliceModel;
    private final BlockStateModel gemsModel;
    private final String id;
    private final FluidStack fluidStack;

    public ModelEntangledChaliceBaked(BlockStateModel chaliceModel, BlockStateModel gemsModel) {
        this.chaliceModel = chaliceModel;
        this.gemsModel = gemsModel;
        this.id = "";
        this.fluidStack = null;
    }

    public ModelEntangledChaliceBaked(BlockStateModel chaliceModel, BlockStateModel gemsModel, String id, FluidStack fluidStack, BlockAndTintGetter level, BlockState blockState, Direction facing, RandomSource rand, ModelData modelData, ChunkSectionLayer renderType) {
        super(level, blockState, facing, rand, modelData, renderType);
        this.chaliceModel = chaliceModel;
        this.gemsModel = gemsModel;
        this.id = id != null ? id : "";
        this.fluidStack = fluidStack;
    }

    public ModelEntangledChaliceBaked(BlockStateModel chaliceModel, BlockStateModel gemsModel, String id, FluidStack fluidStack, ItemStack itemStack, Level world, LivingEntity entity) {
        super(itemStack, world, entity);
        this.chaliceModel = chaliceModel;
        this.gemsModel = gemsModel;
        this.id = id != null ? id : "";
        this.fluidStack = fluidStack;
    }

    public static int getColorSeed(String id) {
        int gemColor;
        if (seeds.containsKey(id)) {
            gemColor = seeds.get(id);
        } else {
            long res = id.hashCode();
            Random rand = new Random(res);
            gemColor = rand.nextInt(0x1000000) | 0xFF000000;
            seeds.put(id, gemColor);
        }
        return gemColor;
    }

    public List<BakedQuad> getGeneralQuads() {
        LinkedList quads = Lists.newLinkedList();
        for (BlockModelPart blockModelPart : this.chaliceModel.collectParts(this.level, BlockPos.ZERO, this.blockState, this.rand)) {
            quads.addAll(blockModelPart.getQuads(null));
        }
        int color = ModelEntangledChaliceBaked.getColorSeed(this.id);
        for (BlockModelPart blockModelPart : this.gemsModel.collectParts(this.level, BlockPos.ZERO, this.blockState, this.rand)) {
            for (BakedQuad quad : blockModelPart.getQuads(null)) {
                int[] data = Arrays.copyOf(quad.vertices(), quad.vertices().length);
                for (int i = 0; i < data.length / 8; ++i) {
                    data[i * 8 + 3] = color;
                }
                quads.add(new BakedQuad(data, quad.tintIndex(), quad.direction(), quad.sprite(), false, 0, true));
            }
        }
        if (!this.fluidStack.isEmpty()) {
            quads.addAll(this.getFluidQuads(this.fluidStack, 4000));
        }
        return quads;
    }

    @Nonnull
    public ModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull ModelData tileData) {
        return IModHelpers.get().getBlockEntityHelpers().get((BlockGetter)world, pos, BlockEntityEntangledChalice.class).map(tile -> {
            ModelData.Builder builder = ModelData.builder();
            builder.with(BlockEntangledChalice.TANK_FLUID, (Object)tile.getTank().getFluid());
            builder.with(BlockEntangledChalice.TANK_ID, (Object)tile.getWorldTankId());
            return builder.build();
        }).orElse(ModelData.EMPTY);
    }

    public List<ChunkSectionLayer> getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return List.of(ChunkSectionLayer.SOLID);
    }

    public List<BakedQuad> handleBlockState(BlockAndTintGetter level, BlockPos pos, BlockState state, Direction side, RandomSource rand, ModelData extraData, ChunkSectionLayer renderType) {
        String tankId = (String)ModelHelpers.getSafeProperty((ModelData)this.modelData, BlockEntangledChalice.TANK_ID, (Object)"");
        FluidStack fluidStack = (FluidStack)ModelHelpers.getSafeProperty((ModelData)this.modelData, BlockEntangledChalice.TANK_FLUID, (Object)FluidStack.EMPTY);
        if (!BlockEntangledChaliceConfig.staticBlockRendering) {
            fluidStack = FluidStack.EMPTY;
        }
        return new ModelEntangledChaliceBaked(this.chaliceModel, this.gemsModel, tankId, fluidStack, level, state, side, rand, this.modelData, renderType).getGeneralQuads();
    }

    public List<BakedQuad> handleItemState(ItemStack itemStack, Level world, LivingEntity entity) {
        String id = FluidUtil.getFluidHandler((ItemStack)itemStack).map(h -> ((ItemEntangledChalice.FluidHandler)((Object)h)).getTankID()).orElse("");
        return new ModelEntangledChaliceBaked(this.chaliceModel, this.gemsModel, id, FluidUtil.getFluidContained((ItemStack)itemStack).orElse(FluidStack.EMPTY), itemStack, world, entity).getGeneralQuads();
    }

    public TextureAtlasSprite particleIcon() {
        return this.chaliceModel.particleIcon();
    }

    protected List<BakedQuad> getFluidQuads(FluidStack fluidStack, int capacity) {
        float height = Math.min(0.95f, (float)fluidStack.getAmount() / (float)capacity) * 0.1875f + 0.8125f;
        ArrayList quads = Lists.newArrayList();
        TextureAtlasSprite texture = IModHelpersNeoForge.get().getRenderHelpers().getFluidIcon(fluidStack, Direction.UP);
        int color = IModHelpersNeoForge.get().getRenderHelpers().getFluidBakedQuadColor(fluidStack);
        ModelEntangledChaliceBaked.addBakedQuadRotated((List)quads, (float)0.1875f, (float)0.8125f, (float)0.1875f, (float)0.8125f, (float)height, (TextureAtlasSprite)texture, (Direction)Direction.UP, (int)ROTATION_FIX[Direction.UP.ordinal()], (boolean)true, (int)color, (float[][])ROTATION_UV);
        return quads;
    }

    public boolean usesBlockLight() {
        return true;
    }

    public UnbakedModel wrapped() {
        return null;
    }

    @Nullable
    public ResolvedModel parent() {
        return null;
    }

    public ItemTransforms getTopTransforms() {
        return ModelHelpers.DEFAULT_CAMERA_TRANSFORMS;
    }

    public String getId() {
        return this.id;
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    public String toString() {
        return "ModelEntangledChaliceBaked(id=" + this.getId() + ", fluidStack=" + String.valueOf(this.getFluidStack()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelEntangledChaliceBaked)) {
            return false;
        }
        ModelEntangledChaliceBaked other = (ModelEntangledChaliceBaked)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        FluidStack this$fluidStack = this.getFluidStack();
        FluidStack other$fluidStack = other.getFluidStack();
        return !(this$fluidStack == null ? other$fluidStack != null : !this$fluidStack.equals(other$fluidStack));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModelEntangledChaliceBaked;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        FluidStack $fluidStack = this.getFluidStack();
        result = result * 59 + ($fluidStack == null ? 43 : $fluidStack.hashCode());
        return result;
    }

    public String debugName() {
        return "evilcraft:entangled_chalice";
    }

    public record Unbaked(ResourceLocation chalice, ResourceLocation gems, Variant.SimpleModelState modelState) implements CustomUnbakedBlockStateModel
    {
        public static final MapCodec<Unbaked> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("chalice").forGetter(Unbaked::chalice), (App)ResourceLocation.CODEC.fieldOf("gems").forGetter(Unbaked::gems), (App)Variant.SimpleModelState.MAP_CODEC.forGetter(Unbaked::modelState)).apply((Applicative)builder, Unbaked::new));
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"entangled_chalice");

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
            resolver.markDependency(this.chalice);
            resolver.markDependency(this.gems);
        }

        public BlockStateModel bake(ModelBaker baker) {
            return new ModelEntangledChaliceBaked(ModelHelpers.bakeSingleBlockStateModel((ModelBaker)baker, (ResourceLocation)this.chalice, (ModelState)this.modelState.asModelState()), ModelHelpers.bakeSingleBlockStateModel((ModelBaker)baker, (ResourceLocation)this.gems, (ModelState)this.modelState.asModelState()));
        }

        public MapCodec<? extends CustomUnbakedBlockStateModel> codec() {
            return CODEC;
        }
    }
}

