/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.blockentity;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.evilcraft.core.blockentity.BlockEntityTankInventory;
import org.cyclops.evilcraft.core.blockentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.blockentity.tickaction.TickComponent;

public abstract class BlockEntityTickingTankInventory<T extends BlockEntityTankInventory>
extends BlockEntityTankInventory {
    private List<TickComponent<T, ITickAction<T>>> tickers = Lists.newArrayList();
    protected int currentState = -1;
    protected int previousState = -1;

    public BlockEntityTickingTankInventory(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, int inventorySize, int stackSize, int tankSize, Fluid acceptedFluid) {
        super(type, blockPos, blockState, inventorySize, stackSize, tankSize, acceptedFluid);
    }

    protected int addTicker(TickComponent<T, ITickAction<T>> ticker) {
        this.tickers.add(ticker);
        return this.tickers.size() - 1;
    }

    public List<TickComponent<T, ITickAction<T>>> getTickers() {
        return this.tickers;
    }

    @Override
    public void read(ValueInput valueInput) {
        super.read(valueInput);
        this.currentState = (Integer)valueInput.getInt("currentState").orElseThrow();
        int i = 0;
        for (ValueInput tickerInput : (ValueInput.ValueInputList)valueInput.childrenList("tickers").orElseThrow()) {
            TickComponent<T, ITickAction<T>> ticker = this.tickers.get(i++);
            ticker.setTick((Integer)tickerInput.getInt("tick").orElseThrow());
            ticker.setRequiredTicks(tickerInput.getFloatOr("requiredTicks", 0.0f));
        }
    }

    @Override
    public void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        valueOutput.putInt("currentState", this.currentState);
        ValueOutput.ValueOutputList tickerList = valueOutput.childrenList("tickers");
        for (TickComponent<T, ITickAction<T>> ticker : this.tickers) {
            ValueOutput tag = tickerList.addChild();
            tag.putInt("tick", ticker.getTick());
            tag.putFloat("requiredTicks", ticker.getRequiredTicks());
        }
    }

    protected boolean hasJustWorked() {
        return false;
    }

    public abstract int getNewState();

    public abstract void onStateChanged();

    public int getCurrentState() {
        return this.currentState;
    }

    public static class TickerClient<T extends BlockEntityTickingTankInventory<T>>
    extends BlockEntityTickerDelayed<T> {
        protected void update(Level level, BlockPos pos, BlockState blockState, T blockEntity) {
            super.update(level, pos, blockState, blockEntity);
            if (((BlockEntityTickingTankInventory)((Object)blockEntity)).previousState != ((BlockEntityTickingTankInventory)((Object)blockEntity)).currentState) {
                ((BlockEntityTickingTankInventory)((Object)blockEntity)).previousState = ((BlockEntityTickingTankInventory)((Object)blockEntity)).currentState;
                ((BlockEntityTickingTankInventory)((Object)blockEntity)).onStateChanged();
            }
        }
    }

    public static class TickerServer<T extends BlockEntityTickingTankInventory<T>>
    extends BlockEntityTickerDelayed<T> {
        protected void update(Level level, BlockPos pos, BlockState blockState, T blockEntity) {
            super.update(level, pos, blockState, blockEntity);
            boolean redstone = level.hasNeighborSignal(pos);
            for (TickComponent ticker : ((BlockEntityTickingTankInventory)((Object)blockEntity)).getTickers()) {
                if (ticker.isRedstoneDisableable() && redstone) continue;
                ticker.tick(((BlockEntityTankInventory)((Object)blockEntity)).getInventory().getItem(ticker.getSlot()), ticker.getSlot());
            }
            int newState = ((BlockEntityTickingTankInventory)((Object)blockEntity)).getNewState();
            if (newState != ((BlockEntityTickingTankInventory)((Object)blockEntity)).currentState) {
                ((BlockEntityTickingTankInventory)((Object)blockEntity)).currentState = newState;
                ((BlockEntityTickingTankInventory)((Object)blockEntity)).onStateChanged();
            }
        }
    }

    public static class CapabilityRegistrar<T extends BlockEntityTickingTankInventory<T>>
    extends BlockEntityTankInventory.CapabilityRegistrar<T> {
        public CapabilityRegistrar(Supplier<BlockEntityType<? extends T>> blockEntityType) {
            super(blockEntityType);
        }
    }
}

