/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.weather;

import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.util.Locale;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.cyclops.evilcraft.core.weather.WeatherTypeAny;
import org.cyclops.evilcraft.core.weather.WeatherTypeClear;
import org.cyclops.evilcraft.core.weather.WeatherTypeLightning;
import org.cyclops.evilcraft.core.weather.WeatherTypeRain;

public abstract class WeatherType {
    public static final Codec<WeatherType> CODEC = Codec.STRING.xmap(name -> {
        WeatherType weatherType = WeatherType.valueOf(name);
        if (weatherType == null) {
            throw new JsonSyntaxException(String.format("Could not found the weather '%s'", name));
        }
        return weatherType;
    }, weatherType -> weatherType.toString().toUpperCase(Locale.ENGLISH));
    public static final StreamCodec<ByteBuf, WeatherType> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(name -> {
        WeatherType weatherType = WeatherType.valueOf(name);
        if (weatherType == null) {
            throw new JsonSyntaxException(String.format("Could not found the weather '%s'", name));
        }
        return weatherType;
    }, weatherType -> weatherType.toString().toUpperCase(Locale.ENGLISH));
    public static final WeatherType ANY = new WeatherTypeAny();
    public static final WeatherType CLEAR = new WeatherTypeClear();
    public static final WeatherType RAIN = new WeatherTypeRain();
    public static final WeatherType LIGHTNING = new WeatherTypeLightning();
    public static final WeatherType[] WEATHER_TYPES = new WeatherType[]{CLEAR, RAIN, LIGHTNING};
    private final String name;

    protected WeatherType(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public abstract boolean isActive(Level var1);

    public abstract void activate(ServerLevel var1);

    public abstract void deactivate(ServerLevel var1);

    public void activate(ServerLevel world, boolean activate) {
        if (activate) {
            this.activate(world);
        } else {
            this.deactivate(world);
        }
    }

    public static WeatherType getActiveWeather(Level world) {
        for (WeatherType type : WEATHER_TYPES) {
            if (!type.isActive(world)) continue;
            return type;
        }
        return null;
    }

    public static WeatherType valueOf(String type) {
        Field field;
        try {
            field = WeatherType.class.getField(type);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
        try {
            return (WeatherType)field.get(null);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }
}

