/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.gametest;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import org.cyclops.cyclopscore.gametest.GameTest;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.item.ItemBloodExtractorConfig;

public class GameTestsRecipes {
    public static final String TEMPLATE_EMPTY = "evilcraft:empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 1, 2);

    @GameTest(template="evilcraft:empty10")
    public void testRecipesCombineBloodExtractorsEmpty(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.CRAFTER);
        CrafterBlockEntity crafter = (CrafterBlockEntity)helper.getBlockEntity(POS, CrafterBlockEntity.class);
        helper.setBlock(POS.north(), Blocks.REDSTONE_TORCH);
        crafter.setItem(0, new ItemStack(RegistryEntries.ITEM_BLOOD_EXTRACTOR));
        crafter.setItem(1, new ItemStack(RegistryEntries.ITEM_BLOOD_EXTRACTOR));
        helper.succeedWhen(() -> {
            ItemStack result = ((ItemEntity)helper.findOneEntity(EntityType.ITEM)).getItem();
            helper.assertValueEqual((Object)result.getItem(), (Object)((Item)RegistryEntries.ITEM_BLOOD_EXTRACTOR.get()), (Component)Component.literal((String)"Result item is incorrect"));
            helper.assertValueEqual((Object)((Integer)result.get((Supplier)org.cyclops.cyclopscore.RegistryEntries.COMPONENT_CAPACITY)), (Object)(ItemBloodExtractorConfig.containerSize * 2), (Component)Component.literal((String)"Result item capacity is incorrect"));
            helper.assertTrue(result.get((Supplier)org.cyclops.cyclopscore.RegistryEntries.COMPONENT_FLUID_CONTENT) == null, (Component)Component.literal((String)"Result item fluid content is incorrect"));
        });
    }

    @GameTest(template="evilcraft:empty10")
    public void testRecipesCombineBloodExtractorsFilled(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.CRAFTER);
        CrafterBlockEntity crafter = (CrafterBlockEntity)helper.getBlockEntity(POS, CrafterBlockEntity.class);
        helper.setBlock(POS.north(), Blocks.REDSTONE_TORCH);
        crafter.setItem(0, new ItemStack(RegistryEntries.ITEM_BLOOD_EXTRACTOR));
        crafter.setItem(1, new ItemStack(RegistryEntries.ITEM_BLOOD_EXTRACTOR));
        crafter.getItem(0).set((Supplier)org.cyclops.cyclopscore.RegistryEntries.COMPONENT_FLUID_CONTENT, (Object)SimpleFluidContent.copyOf((FluidStack)new FluidStack(RegistryEntries.FLUID_BLOOD, 1000)));
        crafter.getItem(1).set((Supplier)org.cyclops.cyclopscore.RegistryEntries.COMPONENT_FLUID_CONTENT, (Object)SimpleFluidContent.copyOf((FluidStack)new FluidStack(RegistryEntries.FLUID_BLOOD, 1000)));
        helper.succeedWhen(() -> {
            ItemStack result = ((ItemEntity)helper.findOneEntity(EntityType.ITEM)).getItem();
            helper.assertValueEqual((Object)result.getItem(), (Object)((Item)RegistryEntries.ITEM_BLOOD_EXTRACTOR.get()), (Component)Component.literal((String)"Result item is incorrect"));
            helper.assertValueEqual((Object)((Integer)result.get((Supplier)org.cyclops.cyclopscore.RegistryEntries.COMPONENT_CAPACITY)), (Object)(ItemBloodExtractorConfig.containerSize * 2), (Component)Component.literal((String)"Result item capacity is incorrect"));
            helper.assertValueEqual((Object)((SimpleFluidContent)result.get((Supplier)org.cyclops.cyclopscore.RegistryEntries.COMPONENT_FLUID_CONTENT)).getAmount(), (Object)2000, (Component)Component.literal((String)"Result item fluid content is incorrect"));
        });
    }

    @GameTest(template="evilcraft:empty10")
    public void testRecipesCombineDarkTanksEmpty(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.CRAFTER);
        CrafterBlockEntity crafter = (CrafterBlockEntity)helper.getBlockEntity(POS, CrafterBlockEntity.class);
        helper.setBlock(POS.north(), Blocks.REDSTONE_TORCH);
        crafter.setItem(0, new ItemStack(RegistryEntries.ITEM_DARK_TANK));
        crafter.setItem(1, new ItemStack(RegistryEntries.ITEM_DARK_TANK));
        helper.succeedWhen(() -> {
            ItemStack result = ((ItemEntity)helper.findOneEntity(EntityType.ITEM)).getItem();
            helper.assertValueEqual((Object)result.getItem(), (Object)((Item)RegistryEntries.ITEM_DARK_TANK.get()), (Component)Component.literal((String)"Result item is incorrect"));
            helper.assertValueEqual((Object)((Integer)result.get((Supplier)org.cyclops.cyclopscore.RegistryEntries.COMPONENT_CAPACITY)), (Object)32000, (Component)Component.literal((String)"Result item capacity is incorrect"));
            helper.assertTrue(result.get((Supplier)org.cyclops.cyclopscore.RegistryEntries.COMPONENT_FLUID_CONTENT) == null, (Component)Component.literal((String)"Result item fluid content is incorrect"));
        });
    }

    @GameTest(template="evilcraft:empty10")
    public void testRecipesCombineDarkTanksFilled(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.CRAFTER);
        CrafterBlockEntity crafter = (CrafterBlockEntity)helper.getBlockEntity(POS, CrafterBlockEntity.class);
        helper.setBlock(POS.north(), Blocks.REDSTONE_TORCH);
        crafter.setItem(0, new ItemStack(RegistryEntries.ITEM_DARK_TANK));
        crafter.setItem(1, new ItemStack(RegistryEntries.ITEM_DARK_TANK));
        crafter.getItem(0).set((Supplier)org.cyclops.cyclopscore.RegistryEntries.COMPONENT_FLUID_CONTENT, (Object)SimpleFluidContent.copyOf((FluidStack)new FluidStack(RegistryEntries.FLUID_BLOOD, 1000)));
        crafter.getItem(1).set((Supplier)org.cyclops.cyclopscore.RegistryEntries.COMPONENT_FLUID_CONTENT, (Object)SimpleFluidContent.copyOf((FluidStack)new FluidStack(RegistryEntries.FLUID_BLOOD, 1000)));
        helper.succeedWhen(() -> {
            ItemStack result = ((ItemEntity)helper.findOneEntity(EntityType.ITEM)).getItem();
            helper.assertValueEqual((Object)result.getItem(), (Object)((Item)RegistryEntries.ITEM_DARK_TANK.get()), (Component)Component.literal((String)"Result item is incorrect"));
            helper.assertValueEqual((Object)((Integer)result.get((Supplier)org.cyclops.cyclopscore.RegistryEntries.COMPONENT_CAPACITY)), (Object)32000, (Component)Component.literal((String)"Result item capacity is incorrect"));
            helper.assertValueEqual((Object)((SimpleFluidContent)result.get((Supplier)org.cyclops.cyclopscore.RegistryEntries.COMPONENT_FLUID_CONTENT)).getAmount(), (Object)2000, (Component)Component.literal((String)"Result item fluid content is incorrect"));
        });
    }
}

