/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.common.collect.Lists;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.evilcraft.core.item.ItemBloodContainer;
import org.cyclops.evilcraft.item.ItemInvigoratingPendantConfig;

public class ItemInvigoratingPendant
extends ItemBloodContainer {
    private static final int TICK_MODULUS = IModHelpers.get().getMinecraftHelpers().getSecondInTicks() / 2;

    public ItemInvigoratingPendant(Item.Properties properties) {
        super(properties, ItemInvigoratingPendantConfig.capacity);
    }

    public void clearBadEffects(ItemStack itemStack, Player player) {
        int amount = ItemInvigoratingPendantConfig.usage;
        if (this.canConsume(amount, itemStack, player)) {
            int originalReducableDuration;
            int reducableDuration = originalReducableDuration = ItemInvigoratingPendantConfig.reduceDuration * IModHelpers.get().getMinecraftHelpers().getSecondInTicks();
            Iterator it = Lists.newLinkedList((Iterable)player.getActiveEffects()).iterator();
            while (reducableDuration > 0 && it.hasNext() && this.canConsume(amount, itemStack, player)) {
                MobEffectInstance effect = (MobEffectInstance)it.next();
                Holder potion = effect.getEffect();
                boolean shouldClear = true;
                if (potion != null) {
                    shouldClear = ((MobEffect)potion.value()).getCategory() == MobEffectCategory.HARMFUL;
                }
                if (!(shouldClear &= !effect.isAmbient())) continue;
                int reductionMultiplier = Math.max(1, effect.getAmplifier() + 1);
                int reducableDurationForThisEffect = reducableDuration / reductionMultiplier;
                int remaining = effect.getDuration();
                int toReduce = Math.min(reducableDurationForThisEffect, remaining);
                int toDrain = amount;
                reducableDuration -= toReduce;
                if (remaining == toReduce) {
                    player.removeEffect(potion);
                } else {
                    effect.duration = remaining - toReduce;
                    player.onEffectUpdated(effect, true, null);
                    toDrain = (int)Math.ceil((double)(reductionMultiplier * amount) * ((double)toReduce / (double)originalReducableDuration));
                }
                this.consume(toDrain, itemStack, player);
            }
        }
        if (ItemInvigoratingPendantConfig.fireUsage >= 0 && player.isOnFire() && this.canConsume(ItemInvigoratingPendantConfig.fireUsage, itemStack, player)) {
            player.clearFire();
            this.consume(ItemInvigoratingPendantConfig.fireUsage, itemStack, player);
        }
    }

    public void inventoryTick(ItemStack itemStack, ServerLevel level, Entity entity, @Nullable EquipmentSlot slot) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (IModHelpers.get().getWorldHelpers().efficientTick((Level)level, TICK_MODULUS, new int[]{entity.getId()})) {
                this.clearBadEffects(itemStack, player);
            }
        }
        super.inventoryTick(itemStack, level, entity, slot);
    }
}

