/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import com.mojang.serialization.MapCodec;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.cyclops.cyclopscore.block.BlockWithEntity;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntityBoxOfEternalClosure;
import org.cyclops.evilcraft.core.block.IBlockRarityProvider;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpiritData;

public class BlockBoxOfEternalClosure
extends BlockWithEntity
implements IBlockRarityProvider {
    public static final MapCodec<BlockBoxOfEternalClosure> CODEC = BlockBoxOfEternalClosure.simpleCodec(BlockBoxOfEternalClosure::new);
    public static final String FORGOTTEN_PLAYER = "Forgotten Player";
    private static final int LIGHT_LEVEL = 6;
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final VoxelShape SHAPE_EW = Block.box((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)6.88f, (double)16.0);
    public static final VoxelShape SHAPE_NS = Block.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)6.88f, (double)12.0);
    public static ItemStack boxOfEternalClosureFilled;

    public BlockBoxOfEternalClosure(BlockBehaviour.Properties properties) {
        super(properties, BlockEntityBoxOfEternalClosure::new);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return BlockBoxOfEternalClosure.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)RegistryEntries.BLOCK_ENTITY_BOX_OF_ETERNAL_CLOSURE.get()), (BlockEntityTicker)(level.isClientSide ? new BlockEntityBoxOfEternalClosure.TickerClient() : new BlockEntityBoxOfEternalClosure.TickerServer()));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection());
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction rotation = (Direction)state.getValue(FACING);
        return rotation == Direction.EAST || rotation == Direction.WEST ? SHAPE_EW : SHAPE_NS;
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public static EntityType<?> getSpiritTypeWithFallbackSpirit(ItemStack itemStack) {
        if (itemStack.has(RegistryEntries.COMPONENT_BOX_SPIRIT_DATA)) {
            if (BlockBoxOfEternalClosure.hasPlayer(itemStack)) {
                return EntityType.ZOMBIE;
            }
            EntityType<?> spiritType = BlockBoxOfEternalClosure.getSpiritTypeRaw(itemStack);
            if (spiritType == null && itemStack.has(RegistryEntries.COMPONENT_BOX_SPIRIT_DATA)) {
                return (EntityType)RegistryEntries.ENTITY_VENGEANCE_SPIRIT.get();
            }
            return spiritType;
        }
        return null;
    }

    @Nullable
    public static EntityType<?> getSpiritTypeRaw(ItemStack itemStack) {
        return BlockEntityBoxOfEternalClosure.getSpiritType(itemStack);
    }

    public static void setVengeanceSwarmContent(ItemStack itemStack) {
        EntityVengeanceSpiritData spiritData = new EntityVengeanceSpiritData();
        spiritData.setSwarm(true);
        spiritData.setRandomSwarmTier(new Random());
        CompoundTag spiritTag = IModHelpers.get().getMinecraftHelpers().valueOutputToNbt(spiritData::writeNBT);
        itemStack.set(RegistryEntries.COMPONENT_BOX_SPIRIT_DATA, (Object)spiritTag);
    }

    public static void setPlayerContent(ItemStack itemStack, UUID playerId, String name) {
        EntityVengeanceSpiritData spiritData = new EntityVengeanceSpiritData();
        spiritData.setPlayerId(playerId.toString());
        spiritData.setPlayerName(name);
        CompoundTag spiritTag = IModHelpers.get().getMinecraftHelpers().valueOutputToNbt(spiritData::writeNBT);
        itemStack.set(RegistryEntries.COMPONENT_BOX_PLAYER_ID, (Object)spiritData.getPlayerId());
        itemStack.set(RegistryEntries.COMPONENT_BOX_PLAYER_NAME, (Object)spiritData.getPlayerName());
        itemStack.set(RegistryEntries.COMPONENT_BOX_SPIRIT_DATA, (Object)spiritTag);
    }

    public static String getPlayerName(ItemStack itemStack) {
        return (String)itemStack.getOrDefault(RegistryEntries.COMPONENT_BOX_PLAYER_NAME, (Object)"");
    }

    public static String getPlayerId(ItemStack itemStack) {
        return (String)itemStack.getOrDefault(RegistryEntries.COMPONENT_BOX_PLAYER_ID, (Object)"");
    }

    public static boolean hasPlayer(ItemStack itemStack) {
        return !BlockBoxOfEternalClosure.getPlayerId(itemStack).isEmpty();
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        return IModHelpers.get().getBlockHelpers().doesBlockHaveSolidTopSurface(worldIn, pos);
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (!worldIn.getBlockState(pos.below()).isFaceSturdy((BlockGetter)worldIn, pos.below(), Direction.UP)) {
            worldIn.destroyBlock(pos, true);
        }
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!level.getBlockState(pos.below()).isFaceSturdy((BlockGetter)level, pos.below(), Direction.UP)) {
                serverLevel.scheduleTick(pos, (Block)this, 1);
            }
        }
        return super.updateShape(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult blockRayTraceResult) {
        return IModHelpers.get().getBlockEntityHelpers().get((BlockGetter)worldIn, pos, BlockEntityBoxOfEternalClosure.class).map(tile -> {
            if (tile.isClosed()) {
                tile.open();
                return InteractionResult.SUCCESS;
            }
            return super.useWithoutItem(state, worldIn, pos, player, blockRayTraceResult);
        }).orElseGet(() -> super.useWithoutItem(state, worldIn, pos, player, blockRayTraceResult));
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return IModHelpers.get().getBlockEntityHelpers().get(world, pos, BlockEntityBoxOfEternalClosure.class).map(tile -> tile.getLidAngle() > 0.0f ? 6 : super.getLightEmission(state, world, pos)).orElse(0);
    }

    public void fillItemCategory(NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((ItemLike)this));
        items.add((Object)boxOfEternalClosureFilled);
    }

    @Override
    public Rarity getRarity(ItemStack itemStack) {
        return BlockBoxOfEternalClosure.hasPlayer(itemStack) ? Rarity.RARE : Rarity.UNCOMMON;
    }

    public boolean hasAnalogOutputSignal(BlockState blockState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos blockPos) {
        BlockEntityBoxOfEternalClosure tile;
        if (world.getBlockEntity(blockPos) != null && (tile = (BlockEntityBoxOfEternalClosure)world.getBlockEntity(blockPos)).hasSpirit()) {
            return 15;
        }
        return super.getAnalogOutputSignal(blockState, world, blockPos);
    }
}

