/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;
import org.jetbrains.annotations.Nullable;

public class BlockDarkOre
extends Block
implements IInformationProvider {
    private static final int INCREASE_XP = 5;
    public static final BooleanProperty GLOWING = BooleanProperty.create((String)"glowing");

    public BlockDarkOre(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)GLOWING, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{GLOWING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)GLOWING, (Comparable)Boolean.valueOf(false));
    }

    public int getExpDrop(BlockState state, LevelAccessor level, BlockPos pos, @Nullable BlockEntity blockEntity, @Nullable Entity breaker, ItemStack tool) {
        return 1 + level.getRandom().nextInt(5);
    }

    public void attack(BlockState state, Level worldIn, BlockPos pos, Player player) {
        this.glow(worldIn, pos);
        super.attack(state, worldIn, pos, player);
    }

    public void stepOn(Level world, BlockPos pos, BlockState blockState, Entity entity) {
        this.glow(world, pos);
        super.stepOn(world, pos, blockState, entity);
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult p_225533_6_) {
        this.glow(worldIn, pos);
        return super.useWithoutItem(state, worldIn, pos, player, p_225533_6_);
    }

    private boolean isGlowing(Level world, BlockPos blockPos) {
        return (Boolean)IModHelpers.get().getBlockHelpers().getSafeBlockStateProperty(world.getBlockState(blockPos), (Property)GLOWING, (Comparable)Boolean.valueOf(true));
    }

    private void glow(Level world, BlockPos blockPos) {
        if (world.isClientSide()) {
            this.sparkle(world, blockPos);
        }
        if (!this.isGlowing(world, blockPos)) {
            world.setBlock(blockPos, (BlockState)this.defaultBlockState().setValue((Property)GLOWING, (Comparable)Boolean.valueOf(true)), IModHelpers.get().getMinecraftHelpers().getBlockNotifyClient());
        }
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)GLOWING);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos blockPos, RandomSource rand) {
        if (this.isGlowing((Level)world, blockPos)) {
            world.setBlock(blockPos, (BlockState)this.defaultBlockState().setValue((Property)GLOWING, (Comparable)Boolean.valueOf(false)), IModHelpers.get().getMinecraftHelpers().getBlockNotifyClient());
        }
    }

    public void animateTick(BlockState stateIn, Level world, BlockPos blockPos, RandomSource rand) {
        if (this.isGlowing(world, blockPos)) {
            this.sparkle(world, blockPos);
        }
    }

    private void sparkle(Level world, BlockPos blockPos) {
        RandomSource random = world.random;
        double offset = 0.0625;
        for (int l = 0; l < 6; ++l) {
            double sparkX = (float)blockPos.getX() + random.nextFloat();
            double sparkY = (float)blockPos.getY() + random.nextFloat();
            double sparkZ = (float)blockPos.getZ() + random.nextFloat();
            if (l == 0 && !world.getBlockState(blockPos.offset(0, 1, 0)).isRedstoneConductor((BlockGetter)world, blockPos.offset(0, 1, 0))) {
                sparkY = (double)(blockPos.getY() + 1) + offset;
            }
            if (l == 1 && !world.getBlockState(blockPos.offset(0, -1, 0)).isRedstoneConductor((BlockGetter)world, blockPos.offset(0, -1, 0))) {
                sparkY = (double)blockPos.getY() - offset;
            }
            if (l == 2 && !world.getBlockState(blockPos.offset(0, 0, 1)).isRedstoneConductor((BlockGetter)world, blockPos.offset(0, 0, 1))) {
                sparkZ = (double)(blockPos.getZ() + 1) + offset;
            }
            if (l == 3 && !world.getBlockState(blockPos.offset(0, 0, -1)).isRedstoneConductor((BlockGetter)world, blockPos.offset(0, 0, -1))) {
                sparkZ = (double)blockPos.getZ() - offset;
            }
            if (l == 4 && !world.getBlockState(blockPos.offset(1, 0, 0)).isRedstoneConductor((BlockGetter)world, blockPos.offset(1, 0, 0))) {
                sparkX = (double)(blockPos.getX() + 1) + offset;
            }
            if (l == 5 && !world.getBlockState(blockPos.offset(-1, 0, 0)).isRedstoneConductor((BlockGetter)world, blockPos.offset(-1, 0, 0))) {
                sparkX = (double)blockPos.getX() - offset;
            }
            if (!(sparkX < (double)blockPos.getX() || sparkX > (double)(blockPos.getX() + 1) || sparkY < 0.0 || sparkY > (double)(blockPos.getY() + 1) || sparkZ < (double)blockPos.getZ()) && !(sparkZ > (double)(blockPos.getZ() + 1))) continue;
            world.addParticle((ParticleOptions)ParticleTypes.SMOKE, sparkX, sparkY, sparkZ, 0.0, 0.0, 0.0);
        }
    }

    public MutableComponent getInfo(ItemStack itemStack) {
        return Component.translatable((String)(this.getDescriptionId() + ".info.custom"), (Object[])new Object[]{66}).withStyle(INFO_PREFIX_STYLES);
    }

    public void provideInformation(ItemStack itemStack, Level world, List<Component> list, TooltipFlag iTooltipFlag) {
    }
}

