/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.cyclops.cyclopscore.config.extendedconfig.BlockClientConfig;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfigCommon;
import org.cyclops.cyclopscore.init.IModBase;
import org.cyclops.cyclopscore.init.ModBaseNeoForge;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockDisplayStand;
import org.cyclops.evilcraft.block.BlockDisplayStandConfigClient;
import org.jetbrains.annotations.Nullable;

public class BlockDisplayStandConfig
extends BlockConfigCommon<ModBaseNeoForge<?>> {
    public BlockDisplayStandConfig() {
        super((IModBase)EvilCraft._instance, "display_stand", (eConfig, properties) -> new BlockDisplayStand(properties.requiresCorrectToolForDrops()), (eConfig, block) -> new BlockItem((Block)block, eConfig.createDefaultItemProperties()){

            public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
                super.appendHoverText(stack, context, tooltipDisplay, tooltipAdder, flag);
                ItemStack blockType = ((BlockDisplayStand)((Object)RegistryEntries.BLOCK_DISPLAY_STAND.get())).getDisplayStandType(stack);
                if (blockType != null) {
                    tooltipAdder.accept((Component)((MutableComponent)blockType.getHoverName()).withStyle(ChatFormatting.GRAY));
                }
            }
        });
        EvilCraft._instance.getModEventBus().addListener(this::fillCreativeTab);
    }

    @Nullable
    public BlockClientConfig<ModBaseNeoForge<?>> constructBlockClientConfig() {
        return new BlockDisplayStandConfigClient(this);
    }

    public Collection<ItemStack> getDefaultCreativeTabEntries() {
        return Collections.emptyList();
    }

    protected void fillCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == EvilCraft._instance.getDefaultCreativeTab()) {
            for (ItemStack itemStack : this.dynamicCreativeTabEntries()) {
                event.accept(itemStack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }
    }

    protected Collection<ItemStack> dynamicCreativeTabEntries() {
        NonNullList list = NonNullList.create();
        ((BlockDisplayStand)((Object)this.getInstance())).fillItemCategory((NonNullList<ItemStack>)list);
        return list;
    }
}

