/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity.tickaction.bloodinfuser;

import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.mutable.MutableInt;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.evilcraft.blockentity.BlockEntityBloodInfuser;
import org.cyclops.evilcraft.blockentity.tickaction.EmptyFluidContainerInTankTickAction;
import org.cyclops.evilcraft.blockentity.tickaction.bloodinfuser.BloodInfuserTickAction;
import org.cyclops.evilcraft.core.blockentity.upgrade.UpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.blockentity.upgrade.Upgrades;
import org.cyclops.evilcraft.core.fluid.FluidContainerItemWrapperWithSimulation;

public class FluidContainerItemTickAction
extends BloodInfuserTickAction {
    @Override
    public boolean canTick(BlockEntityBloodInfuser tile, ItemStack itemStack, int slot, int tick) {
        return super.canTick(tile, itemStack, slot, tick) && FluidUtil.getFluidHandler((ItemStack)itemStack).isPresent();
    }

    @Override
    public void onTick(BlockEntityBloodInfuser tile, ItemStack itemStack, int slot, int tick) {
        ItemStack infuseStack = this.getInfuseStack(tile);
        if (!infuseStack.isEmpty()) {
            infuseStack = infuseStack.copy();
        }
        IFluidHandler container = FluidUtil.getFluidHandler((ItemStack)infuseStack).orElse(null);
        FluidStack fluidStack = tile.getTank().getFluid().copy();
        MutableInt duration = new MutableInt(100);
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableInt>(duration, BlockEntityBloodInfuser.UPGRADEEVENT_FILLBLOODPERTICK));
        int minAmount = duration.getValue();
        fluidStack.setAmount(Math.min(minAmount, fluidStack.getAmount()));
        int filled = container.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
        if (filled > 0) {
            tile.getTank().drain(filled, IFluidHandler.FluidAction.EXECUTE);
            tile.getInventory().setItem(tile.getTileWorkingMetadata().getConsumeSlot(), infuseStack);
            if (!IModHelpersNeoForge.get().getFluidHelpers().getFluid(container).isEmpty() && IModHelpersNeoForge.get().getFluidHelpers().getAmount(IModHelpersNeoForge.get().getFluidHelpers().getFluid(container)) == IModHelpersNeoForge.get().getFluidHelpers().getCapacity(container) && this.addToProduceSlot(tile, infuseStack)) {
                tile.getInventory().removeItem(tile.getTileWorkingMetadata().getConsumeSlot(), 1);
            }
        } else {
            ItemStack result;
            FluidActionResult filledContainer = FluidUtil.tryFillContainer((ItemStack)infuseStack, (IFluidHandler)tile.getTank(), (int)Integer.MAX_VALUE, null, (boolean)true);
            if (filledContainer.isSuccess() && this.addToProduceSlot(tile, result = filledContainer.getResult())) {
                tile.getInventory().removeItem(tile.getTileWorkingMetadata().getConsumeSlot(), 1);
            }
        }
    }

    @Override
    public int getUnmodifiedRequiredTicks(BlockEntityBloodInfuser tile, int slot) {
        return EmptyFluidContainerInTankTickAction.getRequiredTicks(tile, this.getInfuseStack(tile));
    }

    @Override
    public ItemStack willProduceItem(BlockEntityBloodInfuser tile) {
        ItemStack itemStack = tile.getInventory().getItem(tile.getTileWorkingMetadata().getConsumeSlot());
        if (itemStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null) instanceof FluidContainerItemWrapperWithSimulation) {
            return ItemStack.EMPTY;
        }
        ItemStack smallContainer = FluidUtil.tryFillContainer((ItemStack)itemStack, (IFluidHandler)tile.getTank(), (int)100, null, (boolean)false).getResult();
        if (!smallContainer.isEmpty()) {
            return smallContainer;
        }
        return FluidUtil.tryFillContainer((ItemStack)itemStack, (IFluidHandler)tile.getTank(), (int)IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume(), null, (boolean)false).getResult();
    }
}

