/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;

public class ParticleBubbleExtended
extends TextureSheetParticle {
    private final float gravity;

    public ParticleBubbleExtended(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ, float gravity) {
        super(world, x, y, z);
        this.setSize(0.02f, 0.02f);
        this.quadSize *= this.random.nextFloat() * 0.6f + 0.2f;
        this.xd = motionX * (double)0.2f + (Math.random() * 2.0 - 1.0) * (double)0.02f;
        this.yd = motionY * (double)0.2f + (Math.random() * 2.0 - 1.0) * (double)0.02f;
        this.zd = motionZ * (double)0.2f + (Math.random() * 2.0 - 1.0) * (double)0.02f;
        this.lifetime = (int)(8.0 / (Math.random() * 0.8 + 0.2));
        this.gravity = gravity;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.yd -= (double)this.gravity;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= 0.85;
        this.yd *= 0.85;
        this.zd *= 0.85;
        if (this.lifetime-- <= 0) {
            this.remove();
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }
}

