/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.evilcraft.core.blockentity.BlockEntityBeacon;
import org.joml.Vector4f;

public abstract class RenderBlockEntityBeacon<T extends BlockEntityBeacon>
implements BlockEntityRenderer<T> {
    private static final ResourceLocation BEACON_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/entity/beacon_beam.png");

    public RenderBlockEntityBeacon(BlockEntityRendererProvider.Context context) {
    }

    public AABB getRenderBoundingBox(T blockEntity) {
        return AABB.INFINITE;
    }

    public void render(T tileentity, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, Vec3 cameraPos) {
        this.renderBeacon(tileentity, partialTicks, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
    }

    protected void renderBeacon(T tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (((BlockEntityBeacon)((Object)tile)).isBeamActive()) {
            Vector4f beamColor = ((BlockEntityBeacon)((Object)tile)).getBeamColor();
            BeaconRenderer.renderBeaconBeam((PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (ResourceLocation)BEACON_TEXTURE, (float)partialTicks, (float)1.0f, (long)tile.getLevel().getGameTime(), (int)0, (int)256, (int)IModHelpers.get().getBaseHelpers().RGBToInt((int)(beamColor.x() * 256.0f), (int)(beamColor.y() * 256.0f), (int)(beamColor.z() * 256.0f)), (float)(this.isInnerBeam(tile) ? 0.0f : 0.2f), (float)0.25f);
        }
    }

    protected abstract boolean isInnerBeam(T var1);

    public boolean shouldRenderOffScreen() {
        return true;
    }

    public int getViewDistance() {
        return 256;
    }
}

