/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.evilcraft.block.BlockBoxOfEternalClosure;
import org.cyclops.evilcraft.blockentity.BlockEntityBoxOfEternalClosure;
import org.cyclops.evilcraft.client.render.blockentity.RendererBlockEntityEndPortalBase;
import org.cyclops.evilcraft.client.render.model.ModelBoxOfEternalClosureBaked;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpirit;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class RenderBlockEntityBoxOfEternalClosure
extends RendererBlockEntityEndPortalBase<BlockEntityBoxOfEternalClosure> {
    private static final ResourceLocation beamTexture = ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"textures/entity/beam.png");
    private static final RenderType renderTypeBeam = RenderType.entitySmoothCutout((ResourceLocation)beamTexture);

    public RenderBlockEntityBoxOfEternalClosure(BlockEntityRendererProvider.Context rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public boolean shouldRender(BlockEntityBoxOfEternalClosure blockEntity, Vec3 cameraPos) {
        return blockEntity.getBlockPos() == BlockPos.ZERO || super.shouldRender((BlockEntity)blockEntity, cameraPos);
    }

    public AABB getRenderBoundingBox(BlockEntityBoxOfEternalClosure blockEntity) {
        return AABB.INFINITE;
    }

    public void render(BlockEntityBoxOfEternalClosure tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, Vec3 cameraPos) {
        Direction direction = (Direction)IModHelpers.get().getBlockHelpers().getSafeBlockStateProperty(tile.getLevel().getBlockState(tile.getBlockPos()), BlockBoxOfEternalClosure.FACING, (Comparable)Direction.NORTH);
        matrixStackIn.pushPose();
        int rotation = 0;
        if (direction == Direction.SOUTH) {
            rotation = -90;
        }
        if (direction == Direction.NORTH) {
            rotation = 90;
        }
        if (direction == Direction.WEST) {
            rotation = 180;
        }
        if (direction == Direction.EAST) {
            rotation = 0;
        }
        matrixStackIn.translate(0.5f, 0.5f, 0.5f);
        matrixStackIn.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)rotation));
        matrixStackIn.translate(-0.5f, -0.5f, -0.5f);
        BlockState blockState = (BlockState)tile.getBlockState().setValue(BlockBoxOfEternalClosure.FACING, (Comparable)Direction.NORTH);
        ModelBoxOfEternalClosureBaked model = (ModelBoxOfEternalClosureBaked)IModHelpers.get().getRenderHelpers().getBakedModel(blockState);
        ModelBlockRenderer.renderModel((PoseStack.Pose)matrixStackIn.last(), (VertexConsumer)bufferIn.getBuffer(Sheets.solidBlockSheet()), (BlockStateModel)model.getBoxModel(), (float)1.0f, (float)1.0f, (float)1.0f, (int)combinedLightIn, (int)OverlayTexture.NO_OVERLAY);
        float angle = tile.getPreviousLidAngle() + (tile.getLidAngle() - tile.getPreviousLidAngle()) * partialTicks;
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.5f, 0.5f, 0.5f);
        matrixStackIn.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        matrixStackIn.translate(-0.5f, -0.5f, -0.5f);
        matrixStackIn.translate(0.25f, 0.375f, 0.0f);
        matrixStackIn.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(angle));
        matrixStackIn.translate(-0.25f, -0.375f, 0.0f);
        ModelBlockRenderer.renderModel((PoseStack.Pose)matrixStackIn.last(), (VertexConsumer)bufferIn.getBuffer(Sheets.solidBlockSheet()), (BlockStateModel)model.getBoxLidModel(), (float)1.0f, (float)1.0f, (float)1.0f, (int)combinedLightIn, (int)OverlayTexture.NO_OVERLAY);
        matrixStackIn.popPose();
        if (angle > 0.0f) {
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.0f, 0.75f, 0.0f);
            super.render(tile, partialTicks, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
            matrixStackIn.popPose();
        }
        matrixStackIn.popPose();
        EntityVengeanceSpirit target = tile.getTargetSpirit();
        if (target != null) {
            BlockPos blockpos = tile.getBlockPos();
            float f = RenderBlockEntityBoxOfEternalClosure.getY(tile, partialTicks);
            float f1 = (float)target.getX() + 0.5f - (float)blockpos.getX();
            float f2 = (float)target.getY() + 0.5f - target.getEyeHeight() / 2.0f - (float)blockpos.getY();
            float f3 = (float)target.getZ() + 0.5f - (float)blockpos.getZ();
            matrixStackIn.translate(f1, f2, f3);
            EnderDragonRenderer.renderCrystalBeams((float)(-f1), (float)(-f2 + f), (float)(-f3), (float)partialTicks, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)combinedLightIn);
        }
    }

    @Override
    public boolean shouldRenderFace(Direction direction) {
        return direction == Direction.UP;
    }

    public static float getY(BlockEntityBoxOfEternalClosure p_229051_0_, float p_229051_1_) {
        float f = (float)p_229051_0_.innerRotation + p_229051_1_;
        float f1 = Mth.sin((float)(f * 0.2f)) / 2.0f + 0.5f;
        f1 = (f1 * f1 + f1) * 0.4f;
        return f1 - 1.4f;
    }

    @Override
    public void renderCube(BlockEntityBoxOfEternalClosure tile, Matrix4f p_228883_4_, VertexConsumer vb) {
        this.renderFace(tile, p_228883_4_, vb, 0.3125f, 0.6875f, -0.5f, -0.5f, 1.0f, 1.0f, 0.0f, 0.0f, Direction.UP);
    }
}

