/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.evilcraft.blockentity.BlockEntityEntangledChalice;
import org.joml.Matrix4f;

public class RenderBlockEntityEntangledChalice
implements BlockEntityRenderer<BlockEntityEntangledChalice> {
    public RenderBlockEntityEntangledChalice(BlockEntityRendererProvider.Context context) {
    }

    public boolean shouldRender(BlockEntityEntangledChalice blockEntity, Vec3 cameraPos) {
        return blockEntity.getBlockPos() == BlockPos.ZERO || super.shouldRender((BlockEntity)blockEntity, cameraPos);
    }

    public void render(BlockEntityEntangledChalice tile, float partialTicks, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int combinedLight, int combinedOverlayIn, Vec3 cameraPos) {
        if (tile != null && !tile.getTank().getFluid().isEmpty() && tile.getTank().getFluid().getFluid() != null) {
            try {
                FluidStack fluid = tile.getTank().getFluid();
                IModHelpersNeoForge.get().getRenderHelpers().renderFluidContext(tile.getTank().getFluid(), matrixStack, () -> {
                    float height = Math.min(0.95f, (float)fluid.getAmount() / (float)tile.getTank().getCapacity()) * 0.1875f + 0.8125f;
                    IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
                    int brightness = Math.max(combinedLight, fluid.getFluid().getFluidType().getLightLevel(fluid));
                    int l2 = brightness >> 16 & 0xFFFF;
                    int i3 = brightness & 0xFFFF;
                    TextureAtlasSprite icon = IModHelpersNeoForge.get().getRenderHelpers().getFluidIcon(fluid, Direction.UP);
                    Triple color = IModHelpers.get().getBaseHelpers().intToRGB(renderProperties.getTintColor(fluid.getFluid().defaultFluidState(), (BlockAndTintGetter)tile.getLevel(), tile.getBlockPos()));
                    VertexConsumer vb = renderTypeBuffer.getBuffer(RenderType.text((ResourceLocation)icon.atlasLocation()));
                    Matrix4f matrix = matrixStack.last().pose();
                    vb.addVertex(matrix, 0.1875f, height, 0.1875f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU0(), icon.getV1()).setUv2(l2, i3);
                    vb.addVertex(matrix, 0.1875f, height, 0.8125f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU0(), icon.getV0()).setUv2(l2, i3);
                    vb.addVertex(matrix, 0.8125f, height, 0.8125f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU1(), icon.getV0()).setUv2(l2, i3);
                    vb.addVertex(matrix, 0.8125f, height, 0.1875f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU1(), icon.getV1()).setUv2(l2, i3);
                });
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }
}

