/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.model;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.ModelRenderProperties;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.helper.ModelHelpers;
import org.cyclops.evilcraft.client.render.model.ModelEntangledChaliceBaked;
import org.jetbrains.annotations.Nullable;

public record ItemModelEntangledChalice(ModelEntangledChaliceBaked model, ModelRenderProperties modelRenderProperties) implements ItemModel
{
    public void update(ItemStackRenderState renderState, ItemStack stack, ItemModelResolver itemModelResolver, ItemDisplayContext displayContext, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
        new BlockModelWrapper(List.of(), this.model.handleItemState(stack, (Level)level, entity), this.modelRenderProperties).update(renderState, stack, itemModelResolver, displayContext, level, entity, seed);
    }

    public record Unbaked(ResourceLocation chalice, ResourceLocation gems) implements ItemModel.Unbaked
    {
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"entangled_chalice");
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("chalice").forGetter(Unbaked::chalice), (App)ResourceLocation.CODEC.fieldOf("gems").forGetter(Unbaked::gems)).apply((Applicative)instance, Unbaked::new));

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        public ItemModel bake(ItemModel.BakingContext bakingContext) {
            ModelBaker baker = bakingContext.blockModelBaker();
            ResolvedModel resolvedModel = baker.getModel(this.chalice);
            TextureSlots textureslots = resolvedModel.getTopTextureSlots();
            ModelRenderProperties modelRenderProperties = ModelRenderProperties.fromResolvedModel((ModelBaker)baker, (ResolvedModel)resolvedModel, (TextureSlots)textureslots);
            ModelEntangledChaliceBaked model = new ModelEntangledChaliceBaked(ModelHelpers.bakeSingleBlockStateModel((ModelBaker)baker, (ResourceLocation)this.chalice, (ModelState)BlockModelRotation.X0_Y0), ModelHelpers.bakeSingleBlockStateModel((ModelBaker)baker, (ResourceLocation)this.gems, (ModelState)BlockModelRotation.X0_Y0));
            return new ItemModelEntangledChalice(model, modelRenderProperties);
        }

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
            resolver.markDependency(this.chalice);
            resolver.markDependency(this.gems);
        }
    }
}

