/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.NeoForgeModelProperties;
import net.neoforged.neoforge.client.model.block.CustomUnbakedBlockStateModel;
import net.neoforged.neoforge.model.data.ModelData;
import org.cyclops.cyclopscore.client.model.DynamicItemAndBlockModel;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.ModelHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockDisplayStand;
import org.cyclops.evilcraft.blockentity.BlockEntityDisplayStand;
import org.jetbrains.annotations.Nullable;

public class ModelDisplayStandBaked
extends DynamicItemAndBlockModel {
    private final SingleCache<Material, BlockModelPart> modelCache = new SingleCache((SingleCache.ICacheUpdater)new SingleCache.ICacheUpdater<Material, BlockModelPart>(){

        public BlockModelPart getNewValue(Material key) {
            return ModelDisplayStandBaked.this.bakeModel(key);
        }

        public boolean isKeyEqual(Material k1, Material k2) {
            return k1.equals((Object)k2);
        }
    });
    private final ModelBaker baker;
    private final ResolvedModel resolvedModel;
    private final ModelState modelState;
    private final TextureSlots textureSlots;
    private final TextureAtlasSprite particleIcon;

    public ModelDisplayStandBaked(ModelBaker baker, ResolvedModel resolvedModel, ModelState modelState, TextureSlots textureSlots, TextureAtlasSprite particleIcon) {
        super(true, false);
        this.baker = baker;
        this.resolvedModel = resolvedModel;
        this.modelState = modelState;
        this.textureSlots = textureSlots;
        this.particleIcon = particleIcon;
    }

    public TextureAtlasSprite particleIcon() {
        return this.particleIcon;
    }

    @Nullable
    protected BlockModelPart handleDisplayStandType(ItemStack displayStandType) {
        if (displayStandType != null && !displayStandType.isEmpty()) {
            BlockState blockState = IModHelpers.get().getBlockHelpers().getBlockStateFromItemStack(displayStandType);
            TextureAtlasSprite texture = Minecraft.getInstance().getModelManager().getBlockModelShaper().getBlockModel(blockState).particleIcon();
            return (BlockModelPart)this.modelCache.get((Object)new Material(texture.atlasLocation(), texture.contents().name()));
        }
        return null;
    }

    public BlockModelPart bakeModel(Material material) {
        HashMap resolvedValuesOverride = Maps.newHashMap();
        for (Map.Entry entry : this.textureSlots.resolvedValues.entrySet()) {
            resolvedValuesOverride.put((String)entry.getKey(), material);
        }
        TextureSlots textureSlotsOverride = new TextureSlots((Map)resolvedValuesOverride);
        boolean useAmbientOcclusion = this.resolvedModel.getTopAmbientOcclusion();
        TextureAtlasSprite textureatlassprite = this.resolvedModel.resolveParticleSprite(textureSlotsOverride, this.baker);
        QuadCollection quadcollection = this.resolvedModel.wrapped().geometry().bake(textureSlotsOverride, this.baker, this.modelState, (ModelDebugName)this.resolvedModel, this.resolvedModel.getTopAdditionalProperties());
        RenderTypeGroup renderTypeGroup = (RenderTypeGroup)this.resolvedModel.getTopAdditionalProperties().getOptional(NeoForgeModelProperties.RENDER_TYPE);
        ChunkSectionLayer renderTypes = renderTypeGroup == null || renderTypeGroup.isEmpty() ? null : renderTypeGroup.block();
        return new SimpleModelWrapper(quadcollection, useAmbientOcclusion, textureatlassprite, renderTypes);
    }

    @Nonnull
    public ModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull ModelData tileData) {
        return IModHelpers.get().getBlockEntityHelpers().get((BlockGetter)world, pos, BlockEntityDisplayStand.class).map(tile -> {
            ModelData.Builder builder = ModelData.builder();
            builder.with(BlockDisplayStand.DIRECTION, (Object)tile.getDirection());
            builder.with(BlockDisplayStand.TYPE, (Object)tile.getDisplayStandType());
            return builder.build();
        }).orElse(ModelData.EMPTY);
    }

    public List<ChunkSectionLayer> getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return List.of(ChunkSectionLayer.values());
    }

    public List<BakedQuad> handleBlockState(BlockAndTintGetter level, BlockPos pos, BlockState state, Direction side, RandomSource rand, ModelData extraData, ChunkSectionLayer renderType) {
        LinkedList quads = Lists.newLinkedList();
        BlockModelPart blockModelPart = this.handleDisplayStandType((ItemStack)ModelHelpers.getSafeProperty((ModelData)this.getModelData(level, pos), BlockDisplayStand.TYPE, (Object)ItemStack.EMPTY));
        if (blockModelPart != null) {
            quads.addAll(blockModelPart.getQuads(null));
        }
        return quads;
    }

    public List<BakedQuad> handleItemState(@Nullable ItemStack stack, @Nullable Level level, @Nullable LivingEntity entity) {
        LinkedList quads = Lists.newLinkedList();
        BlockModelPart blockModelPart = this.handleDisplayStandType(((BlockDisplayStand)((Object)RegistryEntries.BLOCK_DISPLAY_STAND.get())).getDisplayStandType(stack));
        if (blockModelPart != null) {
            quads.addAll(blockModelPart.getQuads(null));
        }
        return quads;
    }

    public List<BakedQuad> getGeneralQuads() {
        throw new UnsupportedOperationException("getGeneralQuads is not supported in a factory");
    }

    public boolean usesBlockLight() {
        return true;
    }

    public UnbakedModel wrapped() {
        return null;
    }

    @Nullable
    public ResolvedModel parent() {
        return null;
    }

    public ItemTransforms getTopTransforms() {
        return ModelHelpers.DEFAULT_CAMERA_TRANSFORMS;
    }

    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos) {
        return level.getBlockEntity(pos, (BlockEntityType)RegistryEntries.BLOCK_ENTITY_DISPLAY_STAND.get()).map(tile -> {
            ModelData.Builder builder = ModelData.builder();
            builder.with(BlockDisplayStand.DIRECTION, (Object)tile.getDirection());
            builder.with(BlockDisplayStand.TYPE, (Object)tile.getDisplayStandType());
            return builder.build();
        }).orElse(ModelData.EMPTY);
    }

    public TextureAtlasSprite particleIcon(BlockAndTintGetter level, BlockPos pos, BlockState state) {
        BlockModelPart part = this.handleDisplayStandType((ItemStack)ModelHelpers.getSafeProperty((ModelData)this.getModelData(level, pos), BlockDisplayStand.TYPE, (Object)ItemStack.EMPTY));
        if (part != null) {
            return part.particleIcon();
        }
        return this.particleIcon();
    }

    public String debugName() {
        return "evilcraft:display_stand";
    }

    public record Unbaked(ResourceLocation base, Variant.SimpleModelState modelState) implements CustomUnbakedBlockStateModel
    {
        public static final MapCodec<Unbaked> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("base").forGetter(Unbaked::base), (App)Variant.SimpleModelState.MAP_CODEC.forGetter(Unbaked::modelState)).apply((Applicative)builder, Unbaked::new));
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"display_stand");

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
            resolver.markDependency(this.base);
        }

        public BlockStateModel bake(ModelBaker baker) {
            ResolvedModel resolvedModel = baker.getModel(this.base);
            TextureSlots textureslots = resolvedModel.getTopTextureSlots();
            TextureAtlasSprite textureatlassprite = resolvedModel.resolveParticleSprite(textureslots, baker);
            return new ModelDisplayStandBaked(baker, resolvedModel, this.modelState.asModelState(), textureslots, textureatlassprite);
        }

        public MapCodec<? extends CustomUnbakedBlockStateModel> codec() {
            return CODEC;
        }
    }
}

