/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.fluid;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.cyclopscore.init.ModBaseNeoForge;
import org.cyclops.cyclopscore.persist.world.WorldStorage;

public class WorldStorageSharedTank
extends WorldStorage<WorldStorageSharedTank> {
    private Map<String, FluidStack> tankCache;

    public WorldStorageSharedTank(Map<String, FluidStack> tankCache) {
        this.tankCache = tankCache;
    }

    public FluidStack getFluid(String key) {
        return this.tankCache.getOrDefault(key, FluidStack.EMPTY);
    }

    public void setFluid(String key, FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            this.tankCache.remove(key);
        } else {
            this.tankCache.put(key, fluidStack);
        }
        this.setDirty();
    }

    public Set<Map.Entry<String, FluidStack>> getEntries() {
        return this.tankCache.entrySet();
    }

    public static class Access
    extends WorldStorage.Access<WorldStorageSharedTank> {
        public Access(ModBaseNeoForge<?> mod) {
            super(new SavedDataType(mod.getModId() + "_shared_tank", ctx -> new WorldStorageSharedTank(Maps.newHashMap()), ctx -> RecordCodecBuilder.create(instance -> instance.group((App)RecordCodecBuilder.point((Object)ctx.levelOrThrow()), (App)Codec.dispatchedMap((Codec)Codec.STRING, key -> FluidStack.OPTIONAL_CODEC).fieldOf("tank_cache").forGetter(data -> data.tankCache)).apply((Applicative)instance, (level, tankCache) -> new WorldStorageSharedTank(Maps.newHashMap((Map)tankCache))))), mod);
        }
    }
}

