/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.helper;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.blockentity.BlockEntityWorking;

public class ParticleHelpers {
    public static void spawnBloodSplashParticles(Level level, BlockPos blockPos, int velocity, int amount) {
        RandomSource random = level.getRandom();
        for (int i = 0; i < amount; ++i) {
            float x_r = (float)blockPos.getX() + random.nextFloat();
            float y_r = (float)blockPos.getY() + random.nextFloat();
            float z_r = (float)blockPos.getZ() + random.nextFloat();
            level.addParticle((ParticleOptions)RegistryEntries.PARTICLE_BLOOD_SPLASH.get(), (double)x_r, (double)y_r, (double)z_r, velocity == 0 ? 0.0 : (double)random.nextInt(velocity), velocity == 0 ? 0.0 : (double)random.nextInt(velocity), velocity == 0 ? 0.0 : (double)random.nextInt(velocity));
        }
    }

    public static void spawnRandomBloodBubbleParticles(@Nullable BlockEntityWorking tile, Level world, BlockPos blockPos, RandomSource random, Direction rotatedDirection) {
        if (tile != null && random.nextInt(10) == 0 && tile.isVisuallyWorking()) {
            for (int i = 0; i < 1 + random.nextInt(5); ++i) {
                double particleX = (double)(blockPos.getX() - rotatedDirection.getStepX() + (rotatedDirection == Direction.EAST ? 1 : 0)) + (rotatedDirection == Direction.NORTH || rotatedDirection == Direction.SOUTH ? 0.3 + random.nextDouble() * 0.4 : 0.0);
                double particleY = (double)blockPos.getY() + 0.1 + random.nextDouble() * 0.5;
                double particleZ = (double)(blockPos.getZ() - rotatedDirection.getStepZ() + (rotatedDirection == Direction.SOUTH ? 1 : 0)) + (rotatedDirection == Direction.EAST || rotatedDirection == Direction.WEST ? 0.3 + random.nextDouble() * 0.4 : 0.0);
                float particlemotionX = -0.1f + random.nextFloat() * 0.2f;
                float particlemotionY = 0.01f;
                float particlemotionZ = -0.1f + random.nextFloat() * 0.2f;
                world.addParticle((ParticleOptions)RegistryEntries.PARTICLE_BLOOD_BUBBLE.get(), particleX, particleY, particleZ, (double)particlemotionX, (double)particlemotionY, (double)particlemotionZ);
            }
        }
    }
}

