/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.recipe.type;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockDarkTank;
import org.cyclops.evilcraft.item.ItemBloodExtractor;

public class RecipeBloodExtractorCombination
extends CustomRecipe {
    private final int maxCapacity;

    public RecipeBloodExtractorCombination(CraftingBookCategory category, int maxCapacity) {
        super(category);
        this.maxCapacity = maxCapacity;
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public boolean matches(CraftingInput grid, Level world) {
        return !this.assemble(grid, (HolderLookup.Provider)world.registryAccess()).isEmpty();
    }

    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return new ItemStack(RegistryEntries.ITEM_BLOOD_EXTRACTOR);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inventory) {
        NonNullList aitemstack = NonNullList.withSize((int)inventory.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < aitemstack.size(); ++i) {
            ItemStack itemstack = inventory.getItem(i);
            aitemstack.set(i, (Object)itemstack.getCraftingRemainder());
        }
        return aitemstack;
    }

    public RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return (RecipeSerializer)RegistryEntries.RECIPESERIALIZER_BLOODEXTRACTOR_COMBINATION.get();
    }

    public ItemStack assemble(CraftingInput grid, HolderLookup.Provider registryAccess) {
        ItemStack output = this.getResultItem(registryAccess).copy();
        int totalCapacity = 0;
        int totalContent = 0;
        int extractors = 0;
        int tanks = 0;
        for (int j = 0; j < grid.size(); ++j) {
            FluidStack fluidStack;
            ItemStack element = grid.getItem(j).copy().split(1);
            if (element.isEmpty()) continue;
            if (element.getItem() instanceof BlockItem && ((BlockItem)element.getItem()).getBlock() instanceof BlockDarkTank) {
                tanks += element.getCount();
                fluidStack = FluidUtil.getFluidContained((ItemStack)element).orElse(FluidStack.EMPTY);
                if (!fluidStack.isEmpty()) {
                    if (fluidStack.getFluid() != RegistryEntries.FLUID_BLOOD.get()) {
                        return ItemStack.EMPTY;
                    }
                    totalContent = IModHelpers.get().getBaseHelpers().addSafe(totalContent, fluidStack.getAmount() * element.getCount());
                }
                totalCapacity = IModHelpers.get().getBaseHelpers().addSafe(totalCapacity, IModHelpersNeoForge.get().getFluidHelpers().getFluidHandlerItemCapacity(element).map(IFluidHandlerItemCapacity::getCapacity).orElse(0) * element.getCount());
                continue;
            }
            if (element.getItem() instanceof ItemBloodExtractor) {
                extractors += element.getCount();
                fluidStack = FluidUtil.getFluidContained((ItemStack)element).orElse(FluidStack.EMPTY);
                if (!fluidStack.isEmpty()) {
                    if (fluidStack.getFluid() != RegistryEntries.FLUID_BLOOD.get()) {
                        return ItemStack.EMPTY;
                    }
                    totalContent = IModHelpers.get().getBaseHelpers().addSafe(totalContent, fluidStack.getAmount() * element.getCount());
                }
                totalCapacity = IModHelpers.get().getBaseHelpers().addSafe(totalCapacity, IModHelpersNeoForge.get().getFluidHelpers().getFluidHandlerItemCapacity(element).map(IFluidHandlerItemCapacity::getCapacity).orElse(0) * element.getCount());
                continue;
            }
            return ItemStack.EMPTY;
        }
        if (extractors + tanks < 2 || extractors < 1 || totalCapacity > this.getMaxCapacity()) {
            return ItemStack.EMPTY;
        }
        IFluidHandlerItemCapacity fluidHandlerOutput = IModHelpersNeoForge.get().getFluidHelpers().getFluidHandlerItemCapacity(output).orElse(null);
        fluidHandlerOutput.setCapacity(totalCapacity);
        fluidHandlerOutput.fill(new FluidStack(RegistryEntries.FLUID_BLOOD, totalContent), IFluidHandler.FluidAction.EXECUTE);
        return output;
    }
}

