/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.recipe.type;

import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.cyclopscore.recipe.ItemStackFromIngredient;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.recipe.display.RecipeDisplayBloodInfuser;
import org.cyclops.evilcraft.core.recipe.type.IInventoryFluidTier;

public class RecipeBloodInfuser
implements Recipe<IInventoryFluidTier> {
    private final Optional<Ingredient> inputIngredient;
    private final Optional<FluidStack> inputFluid;
    private final Optional<Integer> inputTier;
    private final Either<ItemStack, ItemStackFromIngredient> outputItem;
    private final int duration;
    private final Optional<Float> xp;
    private PlacementInfo placementInfo;

    public RecipeBloodInfuser(Optional<Ingredient> inputIngredient, Optional<FluidStack> inputFluid, Optional<Integer> inputTier, Either<ItemStack, ItemStackFromIngredient> outputItem, int duration, Optional<Float> xp) {
        this.inputIngredient = inputIngredient;
        this.inputFluid = inputFluid;
        this.inputTier = inputTier;
        this.outputItem = outputItem;
        this.xp = xp;
        this.duration = duration;
    }

    public Optional<Ingredient> getInputIngredient() {
        return this.inputIngredient;
    }

    public Optional<FluidStack> getInputFluid() {
        return this.inputFluid;
    }

    public Optional<Integer> getInputTier() {
        return this.inputTier;
    }

    public Either<ItemStack, ItemStackFromIngredient> getOutputItem() {
        return this.outputItem;
    }

    public ItemStack getOutputItemFirst() {
        return (ItemStack)this.getOutputItem().map(l -> l, ItemStackFromIngredient::getFirstItemStack);
    }

    public int getDuration() {
        return this.duration;
    }

    public Optional<Float> getXp() {
        return this.xp;
    }

    public boolean matches(IInventoryFluidTier inv, Level worldIn) {
        return this.getInputTier().map(t -> t <= inv.getTier()).orElse(true) != false && this.inputIngredient.map(p -> p.test(inv.getItem(0))).orElse(inv.getItem(0).isEmpty()) != false && this.inputFluid.map(f -> f.getFluid() == inv.getFluidHandler().getFluidInTank(0).getFluid()).orElse(inv.getFluidHandler().getFluidInTank(0).isEmpty()) != false && this.inputFluid.map(f -> f.getAmount() <= inv.getFluidHandler().getFluidInTank(0).getAmount()).orElse(inv.getFluidHandler().getFluidInTank(0).isEmpty()) != false;
    }

    public ItemStack assemble(IInventoryFluidTier inv, HolderLookup.Provider registryAccess) {
        return this.getOutputItemFirst().copy();
    }

    public ItemStack getResultItem() {
        return this.getOutputItemFirst().copy();
    }

    public RecipeSerializer<? extends Recipe<IInventoryFluidTier>> getSerializer() {
        return (RecipeSerializer)RegistryEntries.RECIPESERIALIZER_BLOOD_INFUSER.get();
    }

    public RecipeType<? extends Recipe<IInventoryFluidTier>> getType() {
        return (RecipeType)RegistryEntries.RECIPETYPE_BLOOD_INFUSER.get();
    }

    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.create((Ingredient)this.inputIngredient.orElse(Ingredient.of((ItemLike)Items.BUCKET)));
        }
        return this.placementInfo;
    }

    public RecipeBookCategory recipeBookCategory() {
        return (RecipeBookCategory)RegistryEntries.RECIPEBOOKCATEGORY_BLOOD_INFUSER.get();
    }

    public List<RecipeDisplay> display() {
        return List.of(new RecipeDisplayBloodInfuser(this.getInputIngredient().map(Ingredient::display).orElse((SlotDisplay)SlotDisplay.Empty.INSTANCE), this.getInputFluid().orElse(FluidStack.EMPTY), this.getInputTier().orElse(-1), (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(this.getOutputItemFirst()), (SlotDisplay)new SlotDisplay.ItemSlotDisplay(((Block)RegistryEntries.BLOCK_BLOOD_INFUSER.get()).asItem()), this.getDuration(), this.getXp().orElse(Float.valueOf(0.0f)).floatValue()));
    }
}

