/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.recipe.type;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.biome.Biome;
import org.cyclops.cyclopscore.recipe.ItemStackFromIngredient;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.recipe.type.RecipeEnvironmentalAccumulator;
import org.cyclops.evilcraft.core.weather.WeatherType;
import org.cyclops.evilcraft.item.ItemBiomeExtract;
import org.cyclops.evilcraft.item.ItemBiomeExtractConfig;

public class RecipeEnvironmentalAccumulatorBiomeExtract
extends RecipeEnvironmentalAccumulator {
    public RecipeEnvironmentalAccumulatorBiomeExtract(Ingredient inputIngredient, WeatherType inputWeather, Either<ItemStack, ItemStackFromIngredient> outputItem, WeatherType outputWeather, Optional<Integer> duration, Optional<Integer> cooldownTime, Optional<Float> processingSpeed) {
        super(inputIngredient, inputWeather, outputItem, outputWeather, duration, cooldownTime, processingSpeed);
    }

    @Override
    public RecipeSerializer<? extends Recipe<RecipeEnvironmentalAccumulator.Inventory>> getSerializer() {
        return (RecipeSerializer)RegistryEntries.RECIPESERIALIZER_BIOME_EXTRACT.get();
    }

    @Override
    public ItemStack assemble(RecipeEnvironmentalAccumulator.Inventory inventory, HolderLookup.Provider registryAccess) {
        Holder biome = inventory.getWorld().getBiome(inventory.getPos());
        if (ItemBiomeExtractConfig.isCraftingBlacklisted((Holder<Biome>)biome)) {
            return ((ItemBiomeExtract)((Object)RegistryEntries.ITEM_BIOME_EXTRACT.get())).createItemStack(null, 1, (HolderGetter<Biome>)registryAccess.lookupOrThrow(Registries.BIOME));
        }
        return ((ItemBiomeExtract)((Object)RegistryEntries.ITEM_BIOME_EXTRACT.get())).createItemStack((Holder<Biome>)biome, 1, (HolderGetter<Biome>)registryAccess.lookupOrThrow(Registries.BIOME));
    }
}

