/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.recipe.type;

import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.cyclops.cyclopscore.helper.RecipeSerializerHelpers;
import org.cyclops.cyclopscore.recipe.ItemStackFromIngredient;
import org.cyclops.evilcraft.blockentity.BlockEntityBloodInfuserConfig;
import org.cyclops.evilcraft.core.recipe.type.RecipeEnvironmentalAccumulator;
import org.cyclops.evilcraft.core.weather.WeatherType;

public abstract class RecipeSerializerEnvironmentalAccumulatorAbstract<T extends RecipeEnvironmentalAccumulator>
implements RecipeSerializer<T> {
    protected final MapCodec<T> codec = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC.fieldOf("input_item").forGetter(RecipeEnvironmentalAccumulator::getInputIngredient), (App)WeatherType.CODEC.fieldOf("input_weather").forGetter(RecipeEnvironmentalAccumulator::getInputWeather), (App)RecipeSerializerHelpers.getCodecItemStackOrTag(() -> BlockEntityBloodInfuserConfig.recipeTagOutputModPriorities).fieldOf("output_item").forGetter(RecipeEnvironmentalAccumulator::getOutputItem), (App)WeatherType.CODEC.fieldOf("output_weather").forGetter(RecipeEnvironmentalAccumulator::getOutputWeather), (App)Codec.INT.optionalFieldOf("duration").forGetter(RecipeEnvironmentalAccumulator::getDurationRaw), (App)Codec.INT.optionalFieldOf("cooldown_time").forGetter(RecipeEnvironmentalAccumulator::getCooldownTimeRaw), (App)Codec.FLOAT.optionalFieldOf("processing_speed").forGetter(RecipeEnvironmentalAccumulator::getProcessingSpeedRaw)).apply((Applicative)builder, this::createRecipe));
    protected final StreamCodec<RegistryFriendlyByteBuf, T> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, RecipeEnvironmentalAccumulator::getInputIngredient, WeatherType.STREAM_CODEC, RecipeEnvironmentalAccumulator::getInputWeather, (StreamCodec)RecipeSerializerHelpers.STREAM_CODEC_ITEMSTACK_OR_TAG, RecipeEnvironmentalAccumulator::getOutputItem, WeatherType.STREAM_CODEC, RecipeEnvironmentalAccumulator::getOutputWeather, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.INT), RecipeEnvironmentalAccumulator::getDurationRaw, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.INT), RecipeEnvironmentalAccumulator::getCooldownTimeRaw, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.FLOAT), RecipeEnvironmentalAccumulator::getProcessingSpeedRaw, this::createRecipe);

    public MapCodec<T> codec() {
        return this.codec;
    }

    public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
        return this.STREAM_CODEC;
    }

    protected WeatherType getWeatherType(String type) throws JsonSyntaxException {
        WeatherType weather = WeatherType.valueOf(type);
        if (weather == null) {
            throw new JsonSyntaxException(String.format("Could not found the weather '%s'", type));
        }
        return weather;
    }

    protected abstract T createRecipe(Ingredient var1, WeatherType var2, Either<ItemStack, ItemStackFromIngredient> var3, WeatherType var4, Optional<Integer> var5, Optional<Integer> var6, Optional<Float> var7);
}

