/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.enchantment.component;

import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.cyclops.cyclopscore.helper.EnchantmentHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.algorithm.Wrapper;

public class EnchantmentEffectComponentStopDamage {
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void unusingEvent(LivingDamageEvent.Pre event) {
        ItemStack itemStack;
        LivingEntity entity;
        InteractionHand hand;
        if (!event.getEntity().level().isClientSide() && event.getContainer().getSource().getEntity() instanceof LivingEntity && (hand = (entity = (LivingEntity)event.getContainer().getSource().getEntity()).getUsedItemHand()) != null && this.stopDamage(itemStack = entity.getItemInHand(hand))) {
            event.getContainer().setNewDamage(0.0f);
            entity.releaseUsingItem();
            entity.setItemInHand(hand, itemStack);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void unusingEvent(BlockEvent.BreakEvent event) {
        ItemStack itemStack;
        InteractionHand hand;
        if (!event.getPlayer().level().isClientSide() && (hand = event.getPlayer().getUsedItemHand()) != null && this.stopDamage(itemStack = event.getPlayer().getItemInHand(hand))) {
            event.getPlayer().setItemInHand(hand, itemStack);
            event.setCanceled(true);
            event.getPlayer().releaseUsingItem();
        }
    }

    public boolean stopDamage(ItemStack itemStack) {
        Wrapper<Boolean> ret = new Wrapper<Boolean>(false);
        EnchantmentHelpers.runIterationOnItem((ItemStack)itemStack, (enchantment, level) -> {
            int maxDamage;
            if (((Boolean)((Enchantment)enchantment.value()).effects().getOrDefault((DataComponentType)RegistryEntries.ENCHANTMENTEFFECT_COMPONENT_STOP_DAMAGE.get(), (Object)false)).booleanValue() && (maxDamage = itemStack.getMaxDamage()) > 0) {
                int damageBorder = maxDamage - 5;
                if (itemStack.getDamageValue() >= damageBorder) {
                    itemStack.setDamageValue(damageBorder);
                    ret.set(true);
                }
            }
        });
        return ret.get();
    }
}

