/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.Level;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.entity.block.EntityLightningBombPrimedConfig;

public class EntityLightningBombPrimed
extends PrimedTnt {
    private static final float EXPLOSION_STRENGTH = 1.0f;
    @Nullable
    private LivingEntity placer;

    public EntityLightningBombPrimed(EntityType<? extends EntityLightningBombPrimed> type, Level world) {
        super(type, world);
        this.setFuse();
    }

    public EntityLightningBombPrimed(Level world, double x, double y, double z, @Nullable LivingEntity placer) {
        this((EntityType<? extends EntityLightningBombPrimed>)((EntityType)RegistryEntries.ENTITY_LIGHTNING_BOMB_PRIMED.get()), world);
        this.setPos(x, y, z);
        double d0 = world.random.nextDouble() * 6.2831854820251465;
        this.setDeltaMovement(-Math.sin(d0) * 0.02, 0.2f, -Math.cos(d0) * 0.02);
        this.setFuse(80);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.placer = placer;
        this.setFuse();
    }

    @Nullable
    public LivingEntity getOwner() {
        return this.placer;
    }

    protected void setFuse() {
        this.setFuse(EntityLightningBombPrimedConfig.fuse);
    }

    public void tick() {
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.7, -0.5, 0.7));
        }
        if (this.getFuse() - 1 <= 0) {
            this.remove(Entity.RemovalReason.KILLED);
            if (!this.level().isClientSide()) {
                this.explode(this.level(), this.getX(), this.getY(), this.getZ());
            }
        } else {
            this.setFuse(this.getFuse() - 1);
            this.doWaterSplashEffect();
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY() + 0.5, this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    private void explode(Level world, double x, double y, double z) {
        if (!world.isClientSide()) {
            this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 1.0f, Level.ExplosionInteraction.MOB);
            LightningBolt bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(world, EntitySpawnReason.TRIGGERED);
            bolt.snapTo(x, y, z);
        } else {
            Random rand = new Random();
            for (int i = 0; i < 32; ++i) {
                Minecraft.getInstance().levelRenderer.addParticle((ParticleOptions)ParticleTypes.CRIT, false, x, y + rand.nextDouble() * 2.0, z, rand.nextGaussian(), 0.0, rand.nextGaussian());
            }
        }
    }
}

