/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.infobook.pageelement;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.RecipeAppendix;
import org.cyclops.cyclopscore.infobook.pageelement.RecipeAppendixClient;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.tickaction.sanguinaryenvironmentalaccumulator.AccumulateItemTickAction;
import org.cyclops.evilcraft.core.helper.ItemHelpers;
import org.cyclops.evilcraft.core.recipe.display.RecipeDisplayEnvironmentalAccumulator;
import org.cyclops.evilcraft.core.weather.WeatherType;
import org.cyclops.evilcraft.infobook.pageelement.EnvironmentalAccumulatorRecipeAppendix;

public class EnvironmentalAccumulatorRecipeAppendixClient
extends RecipeAppendixClient<EnvironmentalAccumulatorRecipeAppendix> {
    private static final ResourceLocation WEATHERS = ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"textures/gui/weathers.png");
    private static final Map<WeatherType, Integer> X_ICON_OFFSETS = new HashMap<WeatherType, Integer>();
    private static final int SLOT_OFFSET_X = 16;
    private static final int SLOT_OFFSET_Y = 23;
    private static final int Y_START = 2;
    protected static final int SLOT_SIZE = 16;

    protected EnvironmentalAccumulatorRecipeAppendixClient(EnvironmentalAccumulatorRecipeAppendix sectionAppendix) {
        super((RecipeAppendix)sectionAppendix);
    }

    public void bakeElement(InfoSection infoSection) {
        Map renderItemHolders = ((EnvironmentalAccumulatorRecipeAppendix)this.getSectionAppendix()).getRenderItemHolders();
        renderItemHolders.put(EnvironmentalAccumulatorRecipeAppendix.INPUT, new RecipeAppendixClient.ItemButton(((EnvironmentalAccumulatorRecipeAppendix)this.getSectionAppendix()).getInfoBook()));
        renderItemHolders.put(EnvironmentalAccumulatorRecipeAppendix.RESULT, new RecipeAppendixClient.ItemButton(((EnvironmentalAccumulatorRecipeAppendix)this.getSectionAppendix()).getInfoBook()));
    }

    public void drawElementInner(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, int width, int height, int page, int mx, int my) {
        boolean sanguinary = this.getTick(gui) % 2 == 1;
        int middle = (width - 16) / 2;
        gui.drawArrowRight(guiGraphics, x + middle - 3, y + 23 + 2);
        RecipeDisplayEntry recipeDisplay = ((EnvironmentalAccumulatorRecipeAppendix)this.getSectionAppendix()).getRecipeDisplay();
        if (recipeDisplay == null) {
            return;
        }
        int tick = this.getTick(gui);
        ContextMap contextMap = SlotDisplayContext.fromLevel((Level)Minecraft.getInstance().level);
        RecipeDisplayEnvironmentalAccumulator display = (RecipeDisplayEnvironmentalAccumulator)recipeDisplay.display();
        ItemStack input = this.prepareItemStacks(display.inputIngredient().resolveForStacks(contextMap), tick);
        ItemStack result = this.prepareItemStack(display.outputItem().resolveForFirstStack(contextMap), tick);
        this.renderItem(gui, guiGraphics, x + 16, y + 23, input, mx, my, EnvironmentalAccumulatorRecipeAppendix.INPUT);
        this.renderItem(gui, guiGraphics, x + 68, y + 23, result, mx, my, EnvironmentalAccumulatorRecipeAppendix.RESULT);
        this.renderItem(gui, guiGraphics, x + middle, y + 23, new ItemStack(sanguinary ? (ItemLike)RegistryEntries.BLOCK_SANGUINARY_ENVIRONMENTAL_ACCUMULATOR.get() : (ItemLike)RegistryEntries.BLOCK_ENVIRONMENTAL_ACCUMULATOR.get()), mx, my, false, null);
        Integer inputX = X_ICON_OFFSETS.get(display.inputWeather());
        if (inputX != null) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, WEATHERS, x + 16, y + 2, (float)inputX.intValue(), 0.0f, 16, 16, 2565, 256);
            gui.drawOuterBorder(guiGraphics, x + 16, y + 2, 16, 16, 1.0f, 1.0f, 1.0f, 0.2f);
            Integer outputX = X_ICON_OFFSETS.get(display.outputWeather());
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, WEATHERS, x + 68, y + 2, (float)outputX.intValue(), 0.0f, 16, 16, 256, 256);
            gui.drawOuterBorder(guiGraphics, x + 68, y + 2, 16, 16, 1.0f, 1.0f, 1.0f, 0.2f);
        }
        if (sanguinary) {
            this.renderItem(gui, guiGraphics, x + middle, y + 2, ItemHelpers.getBloodBucket(), mx, my, false, null);
            Font fontRenderer = gui.getFont();
            int amount = AccumulateItemTickAction.getUsage(display.cooldownTime());
            FluidStack fluidStack = new FluidStack(RegistryEntries.FLUID_BLOOD, amount);
            String line = fluidStack.getAmount() + " mB";
            MultiLineLabel.create((Font)fontRenderer, (Component)Component.literal((String)line), (int)200).renderLeftAlignedNoShadow(guiGraphics, x + middle - 5, y + 16, 9, 0);
        }
    }

    static {
        X_ICON_OFFSETS.put(WeatherType.CLEAR, 0);
        X_ICON_OFFSETS.put(WeatherType.RAIN, 16);
        X_ICON_OFFSETS.put(WeatherType.LIGHTNING, 32);
    }
}

