/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.Collection;
import java.util.Collections;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.cyclops.cyclopscore.config.ConfigurablePropertyCommon;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfigCommon;
import org.cyclops.cyclopscore.init.IModBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.item.ItemRejuvenatedFlesh;

public class ItemRejuvenatedFleshConfig
extends ItemConfigCommon<IModBase> {
    @ConfigurablePropertyCommon(category="item", comment="The amount of blood (mB) this container can hold.", requiresMcRestart=true)
    public static int containerSize = 10000;
    @ConfigurablePropertyCommon(category="item", comment="The amount of blood (mB) that is consumed per bite.")
    public static int biteUsage = 250;

    public ItemRejuvenatedFleshConfig() {
        super((IModBase)EvilCraft._instance, "flesh_rejuvenated", (eConfig, properties) -> new ItemRejuvenatedFlesh(properties.stacksTo(1).component(DataComponents.RARITY, (Object)Rarity.RARE)));
        EvilCraft._instance.getModEventBus().addListener(this::fillCreativeTab);
    }

    public Collection<ItemStack> getDefaultCreativeTabEntries() {
        return Collections.emptyList();
    }

    protected void fillCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == EvilCraft._instance.getDefaultCreativeTab()) {
            for (ItemStack itemStack : this.dynamicCreativeTabEntries()) {
                event.accept(itemStack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }
    }

    protected Collection<ItemStack> dynamicCreativeTabEntries() {
        return ((ItemRejuvenatedFlesh)((Object)this.getInstance())).getDefaultCreativeTabEntries();
    }
}

