/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.weather.WeatherType;
import org.cyclops.evilcraft.entity.item.EntityWeatherContainer;

public class ItemWeatherContainer
extends Item {
    public ItemWeatherContainer(Item.Properties properties) {
        super(properties);
    }

    public static WeatherContainerType getWeatherType(ItemStack itemStack) {
        return (WeatherContainerType)((Object)itemStack.getOrDefault(RegistryEntries.COMPONENT_WEATHER_CONTAINER_TYPE, (Object)WeatherContainerType.EMPTY));
    }

    public static void setWeatherType(ItemStack itemStack, WeatherContainerType type) {
        itemStack.set(RegistryEntries.COMPONENT_WEATHER_CONTAINER_TYPE, (Object)type);
        itemStack.set(DataComponents.RARITY, (Object)type.rarity);
    }

    public ItemUseAnimation getUseAnimation(ItemStack itemStack) {
        return ItemUseAnimation.BOW;
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!world.isClientSide() && ItemWeatherContainer.getWeatherType(itemStack) != WeatherContainerType.EMPTY) {
            world.playSound((Entity)player, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.NEUTRAL, 0.5f, 0.4f / (world.random.nextFloat() * 0.4f + 0.8f));
            EntityWeatherContainer entity = new EntityWeatherContainer(world, (LivingEntity)player, itemStack.copy());
            entity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), -20.0f, 0.5f, 1.0f);
            world.addFreshEntity((Entity)entity);
            itemStack.shrink(1);
        }
        return InteractionResult.SUCCESS.heldItemTransformedTo(itemStack);
    }

    public void onUse(ServerLevel world, ItemStack itemStack) {
        ItemWeatherContainer.getWeatherType(itemStack).onUse(world, itemStack);
    }

    public void onFill(ServerLevel world, ItemStack itemStack) {
        ItemWeatherContainer.getWeatherType(itemStack).onFill(world, itemStack);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        super.appendHoverText(itemStack, context, tooltipDisplay, tooltipAdder, flag);
        WeatherContainerType type = ItemWeatherContainer.getWeatherType(itemStack);
        tooltipAdder.accept((Component)type.description.withStyle(type.damageColor));
    }

    public void fillItemCategory(NonNullList<ItemStack> items) {
        for (WeatherContainerType type : WeatherContainerType.values()) {
            ItemStack stack = new ItemStack((ItemLike)this);
            ItemWeatherContainer.setWeatherType(stack, type);
            items.add((Object)stack);
        }
    }

    public static enum WeatherContainerType {
        EMPTY(null, "empty", ChatFormatting.GRAY, IModHelpers.get().getBaseHelpers().RGBAToInt(125, 125, 125, 255), Rarity.COMMON),
        CLEAR(WeatherType.CLEAR, "clear", ChatFormatting.AQUA, IModHelpers.get().getBaseHelpers().RGBAToInt(30, 150, 230, 255), Rarity.UNCOMMON),
        RAIN(WeatherType.RAIN, "rain", ChatFormatting.DARK_BLUE, IModHelpers.get().getBaseHelpers().RGBAToInt(0, 0, 255, 255), Rarity.UNCOMMON),
        LIGHTNING(WeatherType.LIGHTNING, "lightning", ChatFormatting.GOLD, IModHelpers.get().getBaseHelpers().RGBToInt(255, 215, 0), Rarity.RARE);

        public static final Codec<WeatherContainerType> CODEC;
        public static final StreamCodec<ByteBuf, WeatherContainerType> STREAM_CODEC;
        private final WeatherType type;
        private final MutableComponent description;
        private final ChatFormatting damageColor;
        private final int damageRenderColor;
        private final Rarity rarity;

        private WeatherContainerType(WeatherType type, String description, ChatFormatting damageColor, int damageRenderColor, Rarity rarity) {
            this.type = type;
            this.description = Component.translatable((String)("weather_container.evilcraft." + description));
            this.damageColor = damageColor;
            this.damageRenderColor = damageRenderColor;
            this.rarity = rarity;
        }

        public void onFill(ServerLevel world, ItemStack containerStack) {
            WeatherContainerType currentWeatherType = EMPTY;
            for (WeatherContainerType type : WeatherContainerType.values()) {
                if (type.type == null || !type.type.isActive((Level)world)) continue;
                currentWeatherType = type;
            }
            ItemWeatherContainer.setWeatherType(containerStack, currentWeatherType);
            currentWeatherType.type.deactivate(world);
        }

        public void onUse(ServerLevel world, ItemStack containerStack) {
            if (world.isClientSide()) {
                return;
            }
            if (this.type != null) {
                this.type.activate(world);
            }
            ItemWeatherContainer.setWeatherType(containerStack, EMPTY);
        }

        public static WeatherContainerType getWeatherContainerType(WeatherType weatherType) {
            for (WeatherContainerType type : WeatherContainerType.values()) {
                if (type.type != weatherType) continue;
                return type;
            }
            return null;
        }

        public int getDamageRenderColor() {
            return this.damageRenderColor;
        }

        static {
            CODEC = Codec.STRING.xmap(name -> {
                WeatherContainerType weatherType = WeatherContainerType.valueOf(name);
                if (weatherType == null) {
                    throw new JsonSyntaxException(String.format("Could not found the weather '%s'", name));
                }
                return weatherType;
            }, weatherType -> weatherType.toString().toUpperCase(Locale.ENGLISH));
            STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(name -> {
                WeatherContainerType weatherType = WeatherContainerType.valueOf(name);
                if (weatherType == null) {
                    throw new JsonSyntaxException(String.format("Could not found the weather '%s'", name));
                }
                return weatherType;
            }, weatherType -> weatherType.toString().toUpperCase(Locale.ENGLISH));
        }
    }
}

