/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.itemtintsource;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.item.ItemBiomeExtract;
import org.jetbrains.annotations.Nullable;

public record ItemTintSourceBiomeExtract() implements ItemTintSource
{
    public static final MapCodec<ItemTintSourceBiomeExtract> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.point((Object)new ItemTintSourceBiomeExtract()));

    public int calculate(ItemStack itemStack, @Nullable ClientLevel level, @Nullable LivingEntity entity) {
        ItemBiomeExtract cfr_ignored_0 = (ItemBiomeExtract)((Object)RegistryEntries.ITEM_BIOME_EXTRACT.get());
        Holder<Biome> biome = ItemBiomeExtract.getBiome(itemStack);
        if (biome != null) {
            Triple rgb = IModHelpers.get().getBaseHelpers().intToRGB(((Biome)biome.value()).getFoliageColor());
            return IModHelpers.get().getBaseHelpers().RGBAToInt((int)(((Float)rgb.getLeft()).floatValue() * 255.0f), (int)(((Float)rgb.getMiddle()).floatValue() * 255.0f), (int)(((Float)rgb.getRight()).floatValue() * 255.0f), 255);
        }
        return IModHelpers.get().getBaseHelpers().RGBAToInt(125, 125, 125, 255);
    }

    public MapCodec<? extends ItemTintSource> type() {
        return MAP_CODEC;
    }
}

