/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.loot.functions;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntityBoxOfEternalClosure;

public class LootFunctionCopyBoxOfEternalClosureData
extends LootItemConditionalFunction {
    public static final MapCodec<LootFunctionCopyBoxOfEternalClosureData> CODEC = RecordCodecBuilder.mapCodec(builder -> LootFunctionCopyBoxOfEternalClosureData.commonFields((RecordCodecBuilder.Instance)builder).apply((Applicative)builder, LootFunctionCopyBoxOfEternalClosureData::new));
    public static final LootItemFunctionType TYPE = new LootItemFunctionType(CODEC);

    protected LootFunctionCopyBoxOfEternalClosureData(List<LootItemCondition> conditionsIn) {
        super(conditionsIn);
    }

    public ItemStack run(ItemStack itemStack, LootContext lootContext) {
        BlockEntity tile = (BlockEntity)lootContext.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (tile instanceof BlockEntityBoxOfEternalClosure) {
            CompoundTag tag = new CompoundTag();
            CompoundTag spiritTag = ((BlockEntityBoxOfEternalClosure)tile).getSpiritTag();
            String playerId = ((BlockEntityBoxOfEternalClosure)tile).getPlayerId();
            String playerName = ((BlockEntityBoxOfEternalClosure)tile).getPlayerName();
            if (spiritTag.size() > 0 || playerId != null && !playerId.isEmpty() || playerName != null && !playerName.isEmpty()) {
                itemStack.set(RegistryEntries.COMPONENT_BOX_SPIRIT_DATA, (Object)spiritTag);
                if (playerId != null && !playerId.isEmpty()) {
                    itemStack.set(RegistryEntries.COMPONENT_BOX_PLAYER_ID, (Object)playerId);
                }
                if (playerName != null && !playerName.isEmpty()) {
                    itemStack.set(RegistryEntries.COMPONENT_BOX_PLAYER_NAME, (Object)playerName);
                }
            }
        }
        return itemStack;
    }

    public LootItemFunctionType getType() {
        return TYPE;
    }
}

