/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.metadata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.cyclopscore.metadata.IRegistryExportable;
import org.cyclops.cyclopscore.metadata.RegistryExportableRecipeAbstract;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.tickaction.sanguinaryenvironmentalaccumulator.AccumulateItemTickAction;
import org.cyclops.evilcraft.core.recipe.type.RecipeEnvironmentalAccumulator;

public class RegistryExportableEnvirAccRecipe
extends RegistryExportableRecipeAbstract<RecipeType<RecipeEnvironmentalAccumulator>, RecipeEnvironmentalAccumulator, RecipeEnvironmentalAccumulator.Inventory> {
    public RegistryExportableEnvirAccRecipe() {
        super(() -> RegistryEntries.RECIPETYPE_ENVIRONMENTAL_ACCUMULATOR.get());
    }

    public JsonObject serializeRecipe(RecipeHolder<RecipeEnvironmentalAccumulator> recipe) {
        return RegistryExportableEnvirAccRecipe.serializeRecipeStatic((RecipeEnvironmentalAccumulator)recipe.value());
    }

    public static JsonObject serializeRecipeStatic(RecipeEnvironmentalAccumulator recipe) {
        JsonObject object = new JsonObject();
        List inputItems = recipe.getInputIngredient().items().collect(Collectors.toList());
        JsonArray arrayInputs = new JsonArray();
        for (Holder input : inputItems) {
            arrayInputs.add((JsonElement)IRegistryExportable.serializeItemStack((ItemStack)new ItemStack(input)));
        }
        object.add("input", (JsonElement)arrayInputs);
        object.add("output", (JsonElement)IRegistryExportable.serializeItemStack((ItemStack)recipe.getOutputItemFirst()));
        object.addProperty("inputWeather", recipe.getInputWeather().toString());
        object.addProperty("outputWeather", recipe.getOutputWeather().toString());
        object.addProperty("duration", (Number)recipe.getDuration());
        int amount = AccumulateItemTickAction.getUsage(recipe.getCooldownTime());
        FluidStack fluidStack = new FluidStack(RegistryEntries.FLUID_BLOOD, amount);
        object.add("fluid", (JsonElement)IRegistryExportable.serializeFluidStack((FluidStack)fluidStack));
        return object;
    }
}

