/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraftcompat.modcompat.jei;

import com.google.common.collect.Lists;
import java.text.DecimalFormat;
import java.util.List;
import java.util.function.Consumer;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeHolderType;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntitySpiritFurnace;
import org.cyclops.evilcraft.client.gui.container.ContainerScreenBloodInfuser;
import org.cyclops.evilcraft.client.gui.container.ContainerScreenExaltedCrafter;
import org.cyclops.evilcraft.client.gui.container.ContainerScreenOriginsOfDarkness;
import org.cyclops.evilcraft.client.gui.container.ContainerScreenSanguinaryEnvironmentalAccumulator;
import org.cyclops.evilcraft.client.gui.container.ContainerScreenSpiritFurnace;
import org.cyclops.evilcraft.client.gui.container.ContainerScreenSpiritReanimator;
import org.cyclops.evilcraft.inventory.container.ContainerBloodInfuser;
import org.cyclops.evilcraft.inventory.container.ContainerExaltedCrafter;
import org.cyclops.evilcraft.inventory.container.ContainerSanguinaryEnvironmentalAccumulator;
import org.cyclops.evilcraft.inventory.container.ContainerSpiritFurnace;
import org.cyclops.evilcraft.inventory.container.ContainerSpiritReanimator;
import org.cyclops.evilcraftcompat.RegistryEntriesCompat;
import org.cyclops.evilcraftcompat.modcompat.jei.SubtypeInterpreterActivatableFluidContainer;
import org.cyclops.evilcraftcompat.modcompat.jei.SubtypeInterpreterBoxOfEternalClosure;
import org.cyclops.evilcraftcompat.modcompat.jei.bloodinfuser.BloodInfuserRecipeCategory;
import org.cyclops.evilcraftcompat.modcompat.jei.environmentalaccumulator.EnvironmentalAccumulatorRecipeCategory;
import org.cyclops.evilcraftcompat.modcompat.jei.sanguinaryenvironmentalaccumulator.SanguinaryEnvironmentalAccumulatorRecipeCategory;
import org.cyclops.evilcraftcompat.modcompat.jei.spiritfurnace.SpiritFurnaceRecipeCategory;
import org.cyclops.evilcraftcompat.modcompat.jei.spiritfurnace.SpiritFurnaceRecipeJEI;
import org.cyclops.evilcraftcompat.modcompat.jei.spiritreanimator.SpiritReanimatorRecipeCategory;
import org.cyclops.evilcraftcompat.modcompat.jei.spiritreanimator.SpiritReanimatorRecipeJEI;

@JeiPlugin
public class JEIEvilCraftConfig
implements IModPlugin {
    public static Consumer<List<SpiritFurnaceRecipeJEI>> SPIRIT_FURNACE_RECIPES_REGISTRAR;

    public void registerItemSubtypes(ISubtypeRegistration subtypeRegistry) {
        SubtypeInterpreterActivatableFluidContainer subtypeInterpreter = new SubtypeInterpreterActivatableFluidContainer();
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)RegistryEntries.ITEM_BLOOD_EXTRACTOR.get()), (ISubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)RegistryEntries.ITEM_BLOOD_PEARL_OF_TELEPORTATION.get()), (ISubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)RegistryEntries.ITEM_DARK_TANK.get()), (ISubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)RegistryEntriesCompat.ITEM_INVIGORATING_PENDANT.get()), (ISubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)RegistryEntriesCompat.ITEM_PRIMED_PENDANT.get()), (ISubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)RegistryEntriesCompat.ITEM_KINETICATOR.get()), (ISubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)RegistryEntriesCompat.ITEM_KINETICATOR_REPELLING.get()), (ISubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)RegistryEntries.ITEM_MACE_OF_DISTORTION.get()), (ISubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)RegistryEntriesCompat.ITEM_MACE_OF_DESTRUCTION.get()), (ISubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)RegistryEntriesCompat.ITEM_NECROMANCER_STAFF.get()), (ISubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)RegistryEntriesCompat.ITEM_FLESH_REJUVENATED.get()), (ISubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)RegistryEntries.ITEM_ENTANGLED_CHALICE.get()), (ISubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)RegistryEntries.ITEM_BOX_OF_ETERNAL_CLOSURE.get()), (ISubtypeInterpreter)new SubtypeInterpreterBoxOfEternalClosure());
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new BloodInfuserRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new EnvironmentalAccumulatorRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new SanguinaryEnvironmentalAccumulatorRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new SpiritReanimatorRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new SpiritFurnaceRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registry) {
        this.addRecipes(registry, BloodInfuserRecipeCategory.TYPE, (RecipeType)RegistryEntries.RECIPETYPE_BLOOD_INFUSER.get());
        this.addRecipes(registry, EnvironmentalAccumulatorRecipeCategory.TYPE, (RecipeType)RegistryEntries.RECIPETYPE_ENVIRONMENTAL_ACCUMULATOR.get());
        this.addRecipes(registry, SanguinaryEnvironmentalAccumulatorRecipeCategory.TYPE, (RecipeType)RegistryEntries.RECIPETYPE_ENVIRONMENTAL_ACCUMULATOR.get());
        registry.addRecipes(SpiritReanimatorRecipeCategory.TYPE, SpiritReanimatorRecipeJEI.getAllRecipes());
        SPIRIT_FURNACE_RECIPES_REGISTRAR = recipes -> registry.addRecipes(SpiritFurnaceRecipeCategory.TYPE, recipes);
    }

    protected <I extends RecipeInput, T extends Recipe<I>> void addRecipes(IRecipeRegistration registry, IRecipeHolderType<T> recipeTypeJei, RecipeType<T> recipeType) {
        registry.addRecipes(recipeTypeJei, (List)Lists.newArrayList((Iterable)IModHelpers.get().getMinecraftClientHelpers().getRecipes().byType(recipeType)));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addCraftingStation(BloodInfuserRecipeCategory.TYPE, new ItemStack[]{new ItemStack((ItemLike)RegistryEntries.BLOCK_BLOOD_INFUSER.get())});
        registry.addCraftingStation(EnvironmentalAccumulatorRecipeCategory.TYPE, new ItemStack[]{new ItemStack((ItemLike)RegistryEntries.BLOCK_ENVIRONMENTAL_ACCUMULATOR.get())});
        registry.addCraftingStation(SanguinaryEnvironmentalAccumulatorRecipeCategory.TYPE, new ItemStack[]{new ItemStack((ItemLike)RegistryEntries.BLOCK_SANGUINARY_ENVIRONMENTAL_ACCUMULATOR.get())});
        registry.addCraftingStation(SpiritReanimatorRecipeCategory.TYPE, new ItemStack[]{new ItemStack((ItemLike)RegistryEntries.BLOCK_SPIRIT_REANIMATOR.get())});
        registry.addCraftingStation(SpiritFurnaceRecipeCategory.TYPE, new ItemStack[]{new ItemStack((ItemLike)RegistryEntries.BLOCK_SPIRIT_FURNACE.get())});
        registry.addCraftingStation((IRecipeType)RecipeTypes.CRAFTING, new ItemStack[]{new ItemStack(RegistryEntries.ITEM_EXALTED_CRAFTER_WOODEN)});
        registry.addCraftingStation((IRecipeType)RecipeTypes.CRAFTING, new ItemStack[]{new ItemStack(RegistryEntries.ITEM_EXALTED_CRAFTER)});
        registry.addCraftingStation((IRecipeType)RecipeTypes.CRAFTING, new ItemStack[]{new ItemStack(RegistryEntries.ITEM_EXALTED_CRAFTER_WOODEN_EMPOWERED)});
        registry.addCraftingStation((IRecipeType)RecipeTypes.CRAFTING, new ItemStack[]{new ItemStack(RegistryEntries.ITEM_EXALTED_CRAFTER_EMPOWERED)});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registry) {
        registry.addRecipeTransferHandler(ContainerBloodInfuser.class, null, BloodInfuserRecipeCategory.TYPE, 1, 1, 7, 36);
        registry.addRecipeTransferHandler(ContainerSanguinaryEnvironmentalAccumulator.class, null, SanguinaryEnvironmentalAccumulatorRecipeCategory.TYPE, 0, 1, 6, 36);
        registry.addRecipeTransferHandler(ContainerSpiritReanimator.class, null, SpiritReanimatorRecipeCategory.TYPE, 1, 2, 8, 36);
        registry.addRecipeTransferHandler(ContainerSpiritFurnace.class, null, SpiritFurnaceRecipeCategory.TYPE, 1, 1, BlockEntitySpiritFurnace.SLOTS + 4, 36);
        registry.addRecipeTransferHandler(ContainerExaltedCrafter.class, null, (IRecipeType)RecipeTypes.CRAFTING, 0, 9, 10, 63);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registry) {
        registry.addRecipeClickArea(ContainerScreenBloodInfuser.class, 130, 36, 24, 16, new IRecipeType[]{BloodInfuserRecipeCategory.TYPE});
        registry.addRecipeClickArea(ContainerScreenSanguinaryEnvironmentalAccumulator.class, 105, 36, 24, 16, new IRecipeType[]{SanguinaryEnvironmentalAccumulatorRecipeCategory.TYPE});
        registry.addRecipeClickArea(ContainerScreenSpiritReanimator.class, 147, 26, 10, 24, new IRecipeType[]{SpiritReanimatorRecipeCategory.TYPE});
        registry.addRecipeClickArea(ContainerScreenSpiritFurnace.class, 130, 36, 24, 16, new IRecipeType[]{SpiritFurnaceRecipeCategory.TYPE});
        registry.addRecipeClickArea(ContainerScreenExaltedCrafter.class, 88, 32, 28, 23, new IRecipeType[]{RecipeTypes.CRAFTING});
        registry.addGuiScreenHandler(ContainerScreenOriginsOfDarkness.class, screen -> null);
    }

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"evilcraftcompat", (String)"main");
    }

    public static MutableComponent getDurationSecondsTextComponent(int durationTicks) {
        String seconds = new DecimalFormat("#.##").format((double)durationTicks / (double)IModHelpers.get().getMinecraftHelpers().getSecondInTicks());
        return Component.translatable((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{seconds});
    }
}

