/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraftcompat.modcompat.jei.environmentalaccumulator;

import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.types.IRecipeHolderType;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.recipe.ItemStackFromIngredient;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.recipe.type.RecipeEnvironmentalAccumulator;
import org.cyclops.evilcraftcompat.modcompat.jei.JEIEvilCraftConfig;
import org.cyclops.evilcraftcompat.modcompat.jei.environmentalaccumulator.CommonEnvironmentalAccumulatorRecipeCategory;

public class EnvironmentalAccumulatorRecipeCategory
extends CommonEnvironmentalAccumulatorRecipeCategory {
    public static final IRecipeHolderType<RecipeEnvironmentalAccumulator> TYPE = IRecipeHolderType.create((RecipeType)((RecipeType)RegistryEntries.RECIPETYPE_ENVIRONMENTAL_ACCUMULATOR.get()));
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;

    public EnvironmentalAccumulatorRecipeCategory(IGuiHelper guiHelper) {
        super(guiHelper, (Pair<Integer, Integer>)Pair.of((Object)2, (Object)8), (Pair<Integer, Integer>)Pair.of((Object)76, (Object)8));
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"evilcraftcompat", (String)"textures/gui/environmental_accumulator_gui_jei.png");
        this.background = guiHelper.createDrawable(resourceLocation, 0, 0, 94, 54);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)RegistryEntries.BLOCK_ENVIRONMENTAL_ACCUMULATOR.get()));
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(resourceLocation, 94, 0, 5, 34);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    public int getWidth() {
        return this.background.getWidth();
    }

    public int getHeight() {
        return this.background.getHeight();
    }

    public IRecipeType<RecipeHolder<RecipeEnvironmentalAccumulator>> getRecipeType() {
        return TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return Component.translatable((String)((Block)RegistryEntries.BLOCK_ENVIRONMENTAL_ACCUMULATOR.get()).getDescriptionId());
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<RecipeEnvironmentalAccumulator> recipeHolder, IFocusGroup focuses) {
        RecipeEnvironmentalAccumulator recipe = (RecipeEnvironmentalAccumulator)recipeHolder.value();
        builder.addSlot(RecipeIngredientRole.INPUT, 2, 28).add(recipe.getInputIngredient());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 76, 28).add((Ingredient)recipe.getOutputItem().map(l -> Ingredient.of((ItemLike)l.getItem()), ItemStackFromIngredient::getIngredient));
    }

    @Override
    public void draw(RecipeHolder<RecipeEnvironmentalAccumulator> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw(recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        this.background.draw(guiGraphics);
        this.arrow.draw(guiGraphics, 44, 0);
        Font fontRenderer = Minecraft.getInstance().font;
        MutableComponent duration = JEIEvilCraftConfig.getDurationSecondsTextComponent(((RecipeEnvironmentalAccumulator)recipe.value()).getDuration());
        guiGraphics.drawString(fontRenderer, (Component)duration, (this.background.getWidth() - fontRenderer.width((FormattedText)duration)) / 2, 48, ARGB.opaque((int)-8355712), false);
    }
}

