/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraftcompat.modcompat.jei.spiritreanimator;

import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ARGB;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockSpiritReanimatorConfig;
import org.cyclops.evilcraftcompat.modcompat.jei.JEIEvilCraftConfig;
import org.cyclops.evilcraftcompat.modcompat.jei.spiritreanimator.SpiritReanimatorRecipeJEI;

public class SpiritReanimatorRecipeCategory
implements IRecipeCategory<SpiritReanimatorRecipeJEI> {
    public static final IRecipeType<SpiritReanimatorRecipeJEI> TYPE = IRecipeType.create((String)"evilcraftcompat", (String)"spirit_reanimator", SpiritReanimatorRecipeJEI.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private final IDrawable tankOverlay;

    public SpiritReanimatorRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"evilcraftcompat", (String)"textures/gui/spirit_reanimator_gui_jei.png");
        this.background = guiHelper.createDrawable(resourceLocation, 0, 0, 130, 70);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)RegistryEntries.BLOCK_SPIRIT_REANIMATOR.get()));
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(resourceLocation, 146, 0, 10, 24);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.TOP, false);
        this.tankOverlay = guiHelper.createDrawable(resourceLocation, 130, 0, 16, 58);
    }

    public int getWidth() {
        return this.background.getWidth();
    }

    public int getHeight() {
        return this.background.getHeight();
    }

    public IRecipeType<SpiritReanimatorRecipeJEI> getRecipeType() {
        return TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return Component.translatable((String)((Block)RegistryEntries.BLOCK_SPIRIT_REANIMATOR.get()).getDescriptionId());
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    protected int getMaxTankSize() {
        return BlockSpiritReanimatorConfig.mBPerTick * BlockSpiritReanimatorConfig.requiredTicks;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SpiritReanimatorRecipeJEI recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 50, 17).add(recipe.getInputItem());
        builder.addSlot(RecipeIngredientRole.INPUT, 88, 17).add(Ingredient.of((HolderSet)BuiltInRegistries.ITEM.getOrThrow(ItemTags.EGGS)));
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 6, 6).setOverlay(this.tankOverlay, 0, 0).setFluidRenderer((long)this.getMaxTankSize(), true, 16, 58).add((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)recipe.getInputFluid());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 69, 47).add(recipe.getOutputItem());
    }

    public void draw(SpiritReanimatorRecipeJEI recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
        this.arrow.draw(guiGraphics, 72, 21);
        Font fontRenderer = Minecraft.getInstance().font;
        MutableComponent duration = JEIEvilCraftConfig.getDurationSecondsTextComponent(recipe.getDuration());
        guiGraphics.drawString(fontRenderer, (Component)duration, (this.background.getWidth() - fontRenderer.width((FormattedText)duration)) / 2 + 46, 50, ARGB.opaque((int)-8355712), false);
    }
}

