/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.api.broom;

import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.ExtendedDamageSources;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.api.broom.BroomModifier;
import org.cyclops.evilcraft.api.broom.IBroomModifierRegistry;
import org.cyclops.evilcraft.core.broom.BroomParts;
import org.cyclops.evilcraft.core.broom.PotionEffectBroomCollision;
import org.cyclops.evilcraft.entity.item.EntityBroom;
import org.cyclops.evilcraft.item.ItemBroomConfig;
import org.cyclops.evilcraft.item.ItemMaceOfDistortion;

public class BroomModifiers {
    public static final IBroomModifierRegistry REGISTRY = (IBroomModifierRegistry)EvilCraft._instance.getRegistryManager().getRegistry(IBroomModifierRegistry.class);
    public static BroomModifier MODIFIER_COUNT;
    public static BroomModifier SPEED;
    public static BroomModifier ACCELERATION;
    public static BroomModifier MANEUVERABILITY;
    public static BroomModifier LEVITATION;
    public static BroomModifier DAMAGE;
    public static BroomModifier PARTICLES;
    public static BroomModifier FLAME;
    public static BroomModifier SMASH;
    public static BroomModifier BOUNCY;
    public static BroomModifier WITHERER;
    public static BroomModifier HUNGERER;
    public static BroomModifier KAMIKAZE;
    public static BroomModifier WITHERSHIELD;
    public static BroomModifier STURDYNESS;
    public static BroomModifier EFFICIENCY;
    public static BroomModifier SWIMMING;
    public static BroomModifier ICY;
    public static BroomModifier STICKY;

    public static void init() {
        EvilCraft._instance.getModEventBus().addListener(EventPriority.LOWEST, BroomModifiers::afterItemsRegistered);
        EvilCraft._instance.getModEventBus().addListener(EventPriority.HIGHEST, BroomModifiers::afterAfterItemsRegistered);
        NeoForge.EVENT_BUS.addListener(BroomModifiers::onTagsUpdated);
        NeoForge.EVENT_BUS.addListener(BroomModifiers::onLivingHurt);
    }

    public static void afterItemsRegistered(RegisterEvent event) {
        if (event.getRegistryKey().equals(Registries.ITEM)) {
            BroomParts.loadPre();
            BroomModifiers.loadPre();
        }
    }

    public static void afterAfterItemsRegistered(RegisterEvent event) {
        if (event.getRegistryKey().equals(Registries.POTION)) {
            BroomParts.loadPost();
        }
    }

    public static void onTagsUpdated(TagsUpdatedEvent event) {
        BroomModifiers.loadPost();
    }

    protected static void loadPre() {
        MODIFIER_COUNT = REGISTRY.registerModifier(new BroomModifier(ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"modifier_count"), BroomModifier.Type.ADDITIVE, 0.0f, 1.0f, 3, true, ChatFormatting.BOLD, IModHelpers.get().getBaseHelpers().RGBToInt(0, 0, 0)));
        REGISTRY.overrideDefaultModifierPart(MODIFIER_COUNT, null);
        SPEED = REGISTRY.registerModifier(new BroomModifier(ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"speed"), BroomModifier.Type.ADDITIVE, 0.0f, 100.0f, 3, true, ChatFormatting.RED, IModHelpers.get().getBaseHelpers().RGBToInt(230, 20, 20)));
        ACCELERATION = REGISTRY.registerModifier(new BroomModifier(ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"acceleration"), BroomModifier.Type.ADDITIVE, 0.0f, 100.0f, 3, true, ChatFormatting.DARK_GRAY, IModHelpers.get().getBaseHelpers().RGBToInt(20, 20, 20)));
        MANEUVERABILITY = REGISTRY.registerModifier(new BroomModifier(ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"maneuverability"), BroomModifier.Type.ADDITIVE, 0.0f, 100.0f, 3, true, ChatFormatting.YELLOW, IModHelpers.get().getBaseHelpers().RGBToInt(160, 160, 20)));
        LEVITATION = REGISTRY.registerModifier(new BroomModifier(ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"levitation"), BroomModifier.Type.ADDITIVE, 0.0f, 100.0f, 3, true, ChatFormatting.WHITE, IModHelpers.get().getBaseHelpers().RGBToInt(230, 230, 230)));
        DAMAGE = REGISTRY.registerModifier(new BroomModifier(ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"damage"), BroomModifier.Type.ADDITIVE, 0.0f, 100.0f, 3, false, ChatFormatting.GRAY, IModHelpers.get().getBaseHelpers().RGBToInt(100, 100, 100)));
        PARTICLES = REGISTRY.registerModifier(new BroomModifier(ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"particles"), BroomModifier.Type.ADDITIVE, 0.0f, 50.0f, 1, false, ChatFormatting.LIGHT_PURPLE, IModHelpers.get().getBaseHelpers().RGBToInt(160, 20, 160)));
        FLAME = REGISTRY.registerModifier(new BroomModifier(ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"flame"), BroomModifier.Type.ADDITIVE, 0.0f, 4.0f, 3, false, ChatFormatting.GOLD, IModHelpers.get().getBaseHelpers().RGBToInt(100, 100, 0)));
        SMASH = REGISTRY.registerModifier(new BroomModifier(ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"smash"), BroomModifier.Type.ADDITIVE, 0.0f, 10.0f, 2, false, ChatFormatting.AQUA, IModHelpers.get().getBaseHelpers().RGBToInt(20, 60, 60)));
        BOUNCY = REGISTRY.registerModifier(new BroomModifier(ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"bouncy"), BroomModifier.Type.ADDITIVE, 0.0f, 10.0f, 3, false, ChatFormatting.GREEN, IModHelpers.get().getBaseHelpers().RGBToInt(20, 200, 60)));
        WITHERER = REGISTRY.registerModifier(new BroomModifier(ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"witherer"), BroomModifier.Type.ADDITIVE, 0.0f, 10.0f, 3, false, ChatFormatting.DARK_GRAY, IModHelpers.get().getBaseHelpers().RGBToInt(20, 20, 20)));
        HUNGERER = REGISTRY.registerModifier(new BroomModifier(ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"hungerer"), BroomModifier.Type.ADDITIVE, 0.0f, 10.0f, 3, false, ChatFormatting.DARK_GREEN, IModHelpers.get().getBaseHelpers().RGBToInt(20, 120, 20)));
        KAMIKAZE = REGISTRY.registerModifier(new BroomModifier(ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"kamikaze"), BroomModifier.Type.ADDITIVE, 0.0f, 10.0f, 3, false, ChatFormatting.DARK_GREEN, IModHelpers.get().getBaseHelpers().RGBToInt(20, 120, 20)));
        WITHERSHIELD = REGISTRY.registerModifier(new BroomModifier(ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"withershield"), BroomModifier.Type.ADDITIVE, 0.0f, 5.0f, 4, false, ChatFormatting.DARK_BLUE, IModHelpers.get().getBaseHelpers().RGBToInt(20, 20, 120)));
        STURDYNESS = REGISTRY.registerModifier(new BroomModifier(ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"sturdyness"), BroomModifier.Type.ADDITIVE, 0.0f, 100.0f, 3, false, ChatFormatting.GRAY, IModHelpers.get().getBaseHelpers().RGBToInt(100, 100, 100)));
        EFFICIENCY = REGISTRY.registerModifier(new BroomModifier(ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"efficiency"), BroomModifier.Type.ADDITIVE, 0.0f, 10.0f, 3, false, ChatFormatting.DARK_RED, IModHelpers.get().getBaseHelpers().RGBToInt(92, 29, 29)));
        SWIMMING = REGISTRY.registerModifier(new BroomModifier(ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"swimming"), BroomModifier.Type.ADDITIVE, 0.0f, 100.0f, 3, false, ChatFormatting.AQUA, IModHelpers.get().getBaseHelpers().RGBToInt(150, 150, 235)));
        ICY = REGISTRY.registerModifier(new BroomModifier(ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"icy"), BroomModifier.Type.ADDITIVE, 0.0f, 10.0f, 3, false, ChatFormatting.WHITE, IModHelpers.get().getBaseHelpers().RGBToInt(220, 220, 240)));
        STICKY = REGISTRY.registerModifier(new BroomModifier(ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"sticky"), BroomModifier.Type.ADDITIVE, 0.0f, 10.0f, 3, false, ChatFormatting.GOLD, IModHelpers.get().getBaseHelpers().RGBToInt(78, 58, 12)));
        DAMAGE.addCollisionListener(new BroomModifier.ICollisionListener(){

            @Override
            public void onCollide(EntityBroom broom, Entity entity, float modifierValue) {
                LivingEntity passenger;
                float damage = modifierValue * (float)broom.getLastPlayerSpeed() / 50.0f;
                if (damage > 0.0f && (passenger = broom.getControllingPassenger()) != null) {
                    entity.hurt(ExtendedDamageSources.broomDamage(passenger), damage);
                }
            }
        });
        FLAME.addCollisionListener(new BroomModifier.ICollisionListener(){

            @Override
            public void onCollide(EntityBroom broom, Entity entity, float modifierValue) {
                if (modifierValue > 0.0f) {
                    entity.setRemainingFireTicks((int)modifierValue);
                }
            }
        });
        SMASH.addTickListener(new BroomModifier.ITickListener(){

            @Override
            public void onTick(EntityBroom broom, float modifierValue) {
                Player player;
                double pitch = (double)(broom.getXRot() + 90.0f) * Math.PI / 180.0;
                double yaw = (double)(broom.getYRot() + 90.0f) * Math.PI / 180.0;
                double x = Math.sin(pitch) * Math.cos(yaw);
                double z = Math.sin(pitch) * Math.sin(yaw);
                double y = Math.cos(pitch);
                double r = -0.1;
                BlockPos blockpos = BlockPos.containing((double)(broom.getBoundingBox().minX + x + r), (double)(broom.getBoundingBox().minY + y + r), (double)(broom.getBoundingBox().minZ + z + r));
                BlockPos blockpos1 = BlockPos.containing((double)(broom.getBoundingBox().maxX + x - r), (double)(broom.getBoundingBox().maxY + y - r + 1.0), (double)(broom.getBoundingBox().maxZ + z - r));
                Level world = broom.level();
                float maxHardness = modifierValue;
                float toughnessModifier = Math.min(1.0f, 0.5f + broom.getModifier(STURDYNESS) / (STURDYNESS.getMaxTierValue() * 1.5f) / 2.0f);
                LivingEntity ridingEntity = broom.getControllingPassenger() instanceof LivingEntity ? broom.getControllingPassenger() : null;
                Player player2 = player = broom.getControllingPassenger() instanceof Player ? (Player)broom.getControllingPassenger() : null;
                if (world.hasChunksAt(blockpos, blockpos1)) {
                    for (int i = blockpos.getX(); i <= blockpos1.getX(); ++i) {
                        for (int j = blockpos.getY(); j <= blockpos1.getY(); ++j) {
                            for (int k = blockpos.getZ(); k <= blockpos1.getZ(); ++k) {
                                float hardness;
                                BlockPos pos = new BlockPos(i, j, k);
                                BlockState blockState = world.getBlockState(pos);
                                FluidState fluidState = world.getFluidState(pos);
                                Block block = blockState.getBlock();
                                if (world.isEmptyBlock(pos) || !broom.canConsume(ItemBroomConfig.bloodUsageBlockBreak, ridingEntity) || !((hardness = blockState.getDestroySpeed((BlockGetter)world, pos)) > 0.0f) || !(hardness <= maxHardness)) continue;
                                broom.consume(ItemBroomConfig.bloodUsageBlockBreak, ridingEntity);
                                if (player == null) {
                                    world.destroyBlock(pos, true);
                                } else if (!broom.level().isClientSide()) {
                                    ServerPlayer playerMp = (ServerPlayer)player;
                                    BlockEvent.BreakEvent breakEvent = CommonHooks.fireBlockBreak((Level)world, (GameType)playerMp.gameMode.getGameModeForPlayer(), (ServerPlayer)((ServerPlayer)player), (BlockPos)pos, (BlockState)blockState);
                                    if (!breakEvent.isCanceled()) {
                                        block.playerWillDestroy(world, pos, blockState, player);
                                        if (block.onDestroyedByPlayer(blockState, world, pos, player, true, fluidState)) {
                                            block.destroy((LevelAccessor)world, pos, blockState);
                                            block.playerDestroy(world, player, pos, blockState, world.getBlockEntity(pos), ItemStack.EMPTY);
                                        }
                                        playerMp.connection.send((Packet)new ClientboundBlockUpdatePacket((BlockGetter)world, pos));
                                    }
                                } else if (Minecraft.getInstance().hitResult.getType() == HitResult.Type.BLOCK) {
                                    world.globalLevelEvent(2001, pos, Block.getId((BlockState)blockState));
                                    if (block.onDestroyedByPlayer(blockState, world, pos, player, true, fluidState)) {
                                        block.destroy((LevelAccessor)world, pos, blockState);
                                    }
                                    Minecraft.getInstance().getConnection().send((Packet)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK, pos, ((BlockHitResult)Minecraft.getInstance().hitResult).getDirection()));
                                }
                                broom.setLastPlayerSpeed(broom.getLastPlayerSpeed() * (double)toughnessModifier);
                            }
                        }
                    }
                }
            }
        });
        BOUNCY.addCollisionListener(new BroomModifier.ICollisionListener(){

            @Override
            public void onCollide(EntityBroom broom, Entity entity, float modifierValue) {
                double dz;
                double dy;
                double dx;
                double d;
                float power = modifierValue * (float)broom.getLastPlayerSpeed() / 20.0f;
                if (power > 0.0f && (d = (double)Mth.sqrt((float)((float)((dx = entity.getX() - broom.getX()) * dx + (dy = entity.getY() + (double)entity.getEyeHeight() - broom.getY()) * dy + (dz = entity.getZ() - broom.getZ()) * dz)))) != 0.0) {
                    entity.setDeltaMovement(entity.getDeltaMovement().add(dx /= d, dy /= d, dz /= d).multiply((double)power, (double)power, (double)power));
                    if (broom.level().isClientSide()) {
                        ItemMaceOfDistortion.showEntityDistored(broom.level(), null, entity, (int)(power / 10.0f));
                    }
                }
            }
        });
        WITHERER.addCollisionListener(new PotionEffectBroomCollision((Holder<MobEffect>)MobEffects.WITHER));
        HUNGERER.addCollisionListener(new PotionEffectBroomCollision((Holder<MobEffect>)MobEffects.HUNGER));
        KAMIKAZE.addCollisionListener(new BroomModifier.ICollisionListener(){

            @Override
            public void onCollide(EntityBroom broom, Entity entity, float modifierValue) {
                Level world = broom.level();
                float power = modifierValue * (float)broom.getLastPlayerSpeed() / 5.0f;
                if (power > 0.0f && broom.getControllingPassenger() != null) {
                    broom.lastMounted = null;
                    broom.getControllingPassenger().stopRiding();
                    world.explode(null, broom.getX(), broom.getY(), broom.getZ(), power, Level.ExplosionInteraction.TNT);
                }
            }
        });
        ICY.addCollisionListener(new PotionEffectBroomCollision((Holder<MobEffect>)MobEffects.SLOWNESS, 2));
        STICKY.addCollisionListener(new BroomModifier.ICollisionListener(){

            @Override
            public void onCollide(EntityBroom broom, Entity entity, float modifierValue) {
                if (!entity.level().isClientSide() && !entity.isPassenger() && entity.canRide((Entity)broom)) {
                    entity.startRiding((Entity)broom);
                }
            }
        });
    }

    protected static void loadPost() {
        REGISTRY.clearModifierItems();
        REGISTRY.registerModifiersItem(MODIFIER_COUNT, 1.0f, () -> new ItemStack((ItemLike)Items.NETHER_STAR));
        REGISTRY.registerModifiersItem(MODIFIER_COUNT, 1.0f, () -> new ItemStack(RegistryEntries.ITEM_GARMONBOZIA));
        REGISTRY.registerModifiersItem(SPEED, 1.0f, () -> new ItemStack((ItemLike)Items.REDSTONE));
        REGISTRY.registerModifiersItem(SPEED, 9.0f, () -> new ItemStack((ItemLike)Blocks.REDSTONE_BLOCK));
        REGISTRY.registerModifiersItem(ACCELERATION, 1.0f, () -> new ItemStack((ItemLike)Items.COAL));
        REGISTRY.registerModifiersItem(ACCELERATION, 9.0f, () -> new ItemStack((ItemLike)Blocks.COAL_BLOCK));
        REGISTRY.registerModifiersItem(MANEUVERABILITY, 2.0f, () -> new ItemStack((ItemLike)Items.GLOWSTONE_DUST));
        REGISTRY.registerModifiersItem(MANEUVERABILITY, 8.0f, () -> new ItemStack((ItemLike)Blocks.GLOWSTONE));
        REGISTRY.registerModifiersItem(LEVITATION, 1.0f, () -> new ItemStack((ItemLike)Items.FEATHER));
        REGISTRY.registerModifiersItem(LEVITATION, 50.0f, () -> new ItemStack((ItemLike)Items.PHANTOM_MEMBRANE));
        REGISTRY.registerModifiersItem(DAMAGE, 2.0f, () -> new ItemStack(RegistryEntries.ITEM_DARK_SPIKE));
        REGISTRY.registerModifiersItem(DAMAGE, 1.0f, () -> new ItemStack((ItemLike)Items.QUARTZ));
        REGISTRY.registerModifiersItem(PARTICLES, 1.0f, () -> new ItemStack((ItemLike)Items.GUNPOWDER));
        REGISTRY.registerModifiersItem(FLAME, 1.0f, () -> new ItemStack((ItemLike)Items.BLAZE_POWDER));
        REGISTRY.registerModifiersItem(SMASH, 1.0f, () -> new ItemStack((ItemLike)Items.IRON_PICKAXE));
        REGISTRY.registerModifiersItem(SMASH, 5.0f, () -> new ItemStack((ItemLike)Items.DIAMOND_PICKAXE));
        REGISTRY.registerModifiersItem(BOUNCY, 1.0f, () -> new ItemStack((ItemLike)Items.SLIME_BALL));
        REGISTRY.registerModifiersItem(BOUNCY, 9.0f, () -> new ItemStack((ItemLike)Blocks.SLIME_BLOCK));
        BroomModifiers.registerModifierTagItem(STURDYNESS, 1.0f, ResourceLocation.fromNamespaceAndPath((String)"c", (String)"stones"));
        REGISTRY.registerModifiersItem(STURDYNESS, 10.0f, () -> new ItemStack((ItemLike)Blocks.OBSIDIAN));
        BroomModifiers.registerModifierTagItem(EFFICIENCY, 1.0f, ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"gems/dark_power"));
        REGISTRY.registerModifiersItem(SWIMMING, 1.0f, () -> new ItemStack((ItemLike)Items.PRISMARINE_SHARD));
        REGISTRY.registerModifiersItem(SWIMMING, 4.0f, () -> new ItemStack((ItemLike)Blocks.PRISMARINE));
        REGISTRY.registerModifiersItem(SWIMMING, 9.0f, () -> new ItemStack((ItemLike)Blocks.DARK_PRISMARINE));
        REGISTRY.registerModifiersItem(SWIMMING, 20.0f, () -> new ItemStack((ItemLike)Items.NAUTILUS_SHELL));
        REGISTRY.registerModifiersItem(SWIMMING, 25.0f, () -> new ItemStack((ItemLike)Items.TURTLE_HELMET));
        REGISTRY.registerModifiersItem(ICY, 1.0f, () -> new ItemStack((ItemLike)Blocks.ICE));
        REGISTRY.registerModifiersItem(ICY, 5.0f, () -> new ItemStack((ItemLike)Blocks.PACKED_ICE));
        REGISTRY.registerModifiersItem(ICY, 10.0f, () -> new ItemStack((ItemLike)Blocks.BLUE_ICE));
        REGISTRY.registerModifiersItem(STICKY, 1.0f, () -> new ItemStack((ItemLike)Items.SEAGRASS));
        REGISTRY.registerModifiersItem(STICKY, 2.0f, () -> new ItemStack((ItemLike)Items.KELP));
        REGISTRY.registerModifiersItem(STICKY, 4.0f, () -> new ItemStack((ItemLike)Items.HONEY_BOTTLE));
        REGISTRY.registerModifiersItem(STICKY, 16.0f, () -> new ItemStack((ItemLike)Items.HONEY_BLOCK));
        EvilCraft.clog(String.format("%s Broom modifiers can be applied!", REGISTRY.getModifiers().size()));
    }

    public static void onLivingHurt(LivingDamageEvent.Pre event) {
        EntityBroom broom;
        float modifierValue;
        if (event.getEntity() != null && event.getEntity().getVehicle() instanceof EntityBroom && event.getContainer().getSource().getDirectEntity() instanceof Projectile && (modifierValue = (broom = (EntityBroom)event.getEntity().getVehicle()).getModifier(WITHERSHIELD)) > 0.0f && modifierValue > (float)broom.level().random.nextInt((int)WITHERSHIELD.getMaxTierValue())) {
            event.getContainer().setNewDamage(0.0f);
        }
    }

    public static void registerModifierTagItem(BroomModifier modifier, float value, ResourceLocation name) {
        Optional tag = BuiltInRegistries.ITEM.get(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)name));
        if (tag.isPresent()) {
            ((HolderSet.Named)tag.get()).stream().forEach(holder -> REGISTRY.registerModifiersItem(modifier, value, () -> new ItemStack((ItemLike)holder.value())));
        } else {
            EvilCraft.clog(String.format("Broom modifiers could not find a tag instance for %s", name), org.apache.logging.log4j.Level.WARN);
        }
    }
}

