/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import org.cyclops.cyclopscore.capability.item.ItemHandlerSlotMasked;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.slot.SlotFluidContainer;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockBloodChest;
import org.cyclops.evilcraft.blockentity.tickaction.EmptyFluidContainerInTankTickAction;
import org.cyclops.evilcraft.blockentity.tickaction.bloodchest.RepairItemTickAction;
import org.cyclops.evilcraft.core.blockentity.BlockEntityTickingTankInventory;
import org.cyclops.evilcraft.core.blockentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.blockentity.tickaction.TickComponent;
import org.cyclops.evilcraft.core.fluid.BloodFluidConverter;
import org.cyclops.evilcraft.core.fluid.ImplicitFluidConversionTank;
import org.cyclops.evilcraft.inventory.container.ContainerBloodChest;
import org.cyclops.evilcraft.inventory.slot.SlotRepairable;

public class BlockEntityBloodChest
extends BlockEntityTickingTankInventory<BlockEntityBloodChest>
implements MenuProvider,
LidBlockEntity {
    private static final int TICK_MODULUS = 200;
    public static final int SLOTS_CHEST = 10;
    public static final int SLOTS = 11;
    public static final int SLOT_CONTAINER = 10;
    public static final int LIQUID_PER_SLOT = IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume() * 10;
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level level, BlockPos pos, BlockState blockState) {
            BlockEntityBloodChest.playSound(level, pos, blockState, SoundEvents.CHEST_OPEN);
        }

        protected void onClose(Level level, BlockPos pos, BlockState blockState) {
            BlockEntityBloodChest.playSound(level, pos, blockState, SoundEvents.CHEST_CLOSE);
        }

        protected void openerCountChanged(Level level, BlockPos pos, BlockState blockState, int p_155364_, int p_155365_) {
            BlockEntityBloodChest.this.signalOpenCount(level, pos, blockState, p_155364_, p_155365_);
        }

        protected boolean isOwnContainer(Player player) {
            if (!(player.containerMenu instanceof ContainerBloodChest)) {
                return false;
            }
            Container container = ((ContainerBloodChest)player.containerMenu).getContainerInventory();
            return container == BlockEntityBloodChest.this.getInventory();
        }
    };
    private final ChestLidController chestLidController = new ChestLidController();
    private static final Map<Class<?>, ITickAction<BlockEntityBloodChest>> REPAIR_TICK_ACTIONS = new LinkedHashMap();
    private static final Map<Class<?>, ITickAction<BlockEntityBloodChest>> EMPTY_IN_TANK_TICK_ACTIONS;

    public BlockEntityBloodChest(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.BLOCK_ENTITY_BLOOD_CHEST.get(), blockPos, blockState, 11, 64, LIQUID_PER_SLOT, (Fluid)RegistryEntries.FLUID_BLOOD.get());
        for (int i = 0; i < 10; ++i) {
            this.addTicker(new TickComponent<BlockEntityBloodChest, ITickAction<BlockEntityBloodChest>>(this, REPAIR_TICK_ACTIONS, i));
        }
        this.addTicker(new TickComponent<BlockEntityBloodChest, ITickAction<BlockEntityBloodChest>>(this, EMPTY_IN_TANK_TICK_ACTIONS, 10, false, true));
    }

    public Direction getRotation() {
        if (this.getLevel() == null) {
            return Direction.SOUTH;
        }
        return ((Direction)IModHelpers.get().getBlockHelpers().getSafeBlockStateProperty(this.getBlockState(), BlockBloodChest.FACING, (Comparable)Direction.SOUTH)).getOpposite();
    }

    @Override
    protected SingleUseTank createTank(int tankSize) {
        return new ImplicitFluidConversionTank(tankSize, BloodFluidConverter.getInstance());
    }

    @Override
    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new SimpleInventory(inventorySize, stackSize){

            public boolean canPlaceItem(int slot, ItemStack itemstack) {
                if (slot == 10) {
                    return SlotFluidContainer.checkIsItemValid((ItemStack)itemstack, (Fluid)((Fluid)RegistryEntries.FLUID_BLOOD.get()));
                }
                if (slot <= 10 && slot >= 0) {
                    return SlotRepairable.checkIsItemValid(itemstack);
                }
                return false;
            }

            public void startOpen(Player entityPlayer) {
                super.startOpen(entityPlayer);
                BlockEntityBloodChest.this.startOpen(entityPlayer);
            }

            public void stopOpen(Player entityPlayer) {
                super.stopOpen(entityPlayer);
                BlockEntityBloodChest.this.stopOpen(entityPlayer);
            }

            public boolean stillValid(Player entityPlayer) {
                return super.stillValid(entityPlayer) && BlockEntityBloodChest.this.level != null && BlockEntityBloodChest.this.level.getBlockEntity(BlockEntityBloodChest.this.getBlockPos()) == BlockEntityBloodChest.this;
            }
        };
    }

    @Override
    public int getNewState() {
        return 0;
    }

    @Override
    public void onStateChanged() {
    }

    static void playSound(Level level, BlockPos pos, BlockState blockState, SoundEvent soundEvent) {
        level.playSound((Entity)((Player)null), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, soundEvent, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
    }

    public boolean triggerEvent(int eventType, int value) {
        if (eventType == 1) {
            this.chestLidController.shouldBeOpen(value > 0);
            return true;
        }
        return super.triggerEvent(eventType, value);
    }

    public void startOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.openersCounter.incrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.openersCounter.decrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    protected void signalOpenCount(Level level, BlockPos pos, BlockState blockState, int p_155336_, int value) {
        Block block = blockState.getBlock();
        level.blockEvent(pos, block, 1, value);
    }

    public static void lidAnimateTick(Level level, BlockPos pos, BlockState blockState, BlockEntityBloodChest blockEntity) {
        blockEntity.chestLidController.tickLid();
    }

    public float getOpenNess(float value) {
        return this.chestLidController.getOpenness(value);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
        return new ContainerBloodChest(id, playerInventory, (Container)this.getInventory(), Optional.of(this));
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.evilcraft.blood_chest");
    }

    static {
        REPAIR_TICK_ACTIONS.put(Item.class, new RepairItemTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS = new LinkedHashMap();
        EMPTY_IN_TANK_TICK_ACTIONS.put(Item.class, new EmptyFluidContainerInTankTickAction());
    }

    public static class TickerClient
    extends BlockEntityTickingTankInventory.TickerClient<BlockEntityBloodChest> {
        @Override
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntityBloodChest blockEntity) {
            super.update(level, pos, blockState, blockEntity);
            BlockEntityBloodChest.lidAnimateTick(level, pos, blockState, blockEntity);
        }
    }

    public static class CapabilityRegistrar
    extends BlockEntityTickingTankInventory.CapabilityRegistrar<BlockEntityBloodChest> {
        public CapabilityRegistrar(Supplier<BlockEntityType<? extends BlockEntityBloodChest>> blockEntityType) {
            super(blockEntityType);
        }

        @Override
        public void registerTankInventoryCapabilitiesItem() {
            this.add(Capabilities.ItemHandler.BLOCK, (blockEntity, direction) -> {
                int[] nArray;
                SimpleInventory simpleInventory = blockEntity.getInventory();
                if (direction == Direction.UP || direction == Direction.DOWN) {
                    nArray = IntStream.range(0, 10).toArray();
                } else {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = 10;
                }
                return new ItemHandlerSlotMasked((Container)simpleInventory, nArray);
            });
        }
    }
}

