/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.client.particle.ParticleBlurData;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.evilcraft.RegistryEntries;

public class BlockEntitySpiritPortal
extends CyclopsBlockEntity {
    @NBTPersist
    private Float progress = Float.valueOf(0.0f);

    public BlockEntitySpiritPortal(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.BLOCK_ENTITY_SPIRIT_PORTAL.get(), blockPos, blockState);
    }

    private void showNewBlurParticle() {
        RandomSource rand = this.level.random;
        float scale = 0.6f - rand.nextFloat() * 0.3f;
        float red = rand.nextFloat() * 0.03f + 0.01f;
        float green = rand.nextFloat() * 0.03f;
        float blue = rand.nextFloat() * 0.05f + 0.05f;
        float ageMultiplier = (float)(rand.nextDouble() * 6.5 + 10.0);
        this.level.addParticle((ParticleOptions)new ParticleBlurData(red, green, blue, scale, ageMultiplier), (double)((float)this.getBlockPos().getX() + 0.5f), (double)((float)this.getBlockPos().getY() + 0.5f), (double)((float)this.getBlockPos().getZ() + 0.5f), (double)(rand.nextFloat() * 0.2f - 0.1f), (double)(rand.nextFloat() * 0.2f - 0.1f), (double)(rand.nextFloat() * 0.2f - 0.1f));
    }

    public float getProgress() {
        return this.progress.floatValue();
    }

    public static class Ticker
    extends BlockEntityTickerDelayed<BlockEntitySpiritPortal> {
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntitySpiritPortal blockEntity) {
            super.update(level, pos, blockState, (BlockEntity)blockEntity);
            BlockEntitySpiritPortal blockEntitySpiritPortal = blockEntity;
            blockEntitySpiritPortal.progress = Float.valueOf(blockEntitySpiritPortal.progress.floatValue() + 0.005f);
            if (blockEntity.progress.floatValue() > 1.0f) {
                level.removeBlock(pos, false);
            }
            if (level.isClientSide()) {
                int progressModifier = (int)(blockEntity.getProgress() * 40.0f) + 1;
                if (level.random.nextInt(5) == 0) {
                    level.playLocalSound((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (SoundEvent)RegistryEntries.SOUNDEVENT_EFFECT_VENGEANCEBEAM_BASE.get(), SoundSource.AMBIENT, 0.5f + level.random.nextFloat() * 0.2f, 1.0f, false);
                }
                for (int i = 0; i < level.random.nextInt(progressModifier); ++i) {
                    blockEntity.showNewBlurParticle();
                }
            }
            if (!level.isClientSide()) {
                for (ItemEntity entityItem : level.getEntitiesOfClass(ItemEntity.class, new AABB((double)pos.getX() - 0.5, (double)pos.getY() - 0.5, (double)pos.getZ() - 0.5, (double)pos.getX() + 1.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 1.5))) {
                    if (entityItem.getItem().getItem() != Items.BOOK) continue;
                    ItemEntity entity = new ItemEntity(level, entityItem.getX(), entityItem.getY(), entityItem.getZ(), new ItemStack(RegistryEntries.ITEM_ORIGINS_OF_DARKNESS, entityItem.getItem().getCount()));
                    entity.setDeltaMovement(entityItem.getDeltaMovement());
                    entityItem.remove(Entity.RemovalReason.DISCARDED);
                    level.addFreshEntity((Entity)entity);
                }
            }
        }
    }
}

