/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity.tickaction.spiritfurnace;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.item.WeightedItemStack;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.block.BlockSpiritFurnaceConfig;
import org.cyclops.evilcraft.blockentity.BlockEntitySpiritFurnace;
import org.cyclops.evilcraft.core.blockentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.blockentity.upgrade.UpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.blockentity.upgrade.Upgrades;
import org.cyclops.evilcraft.core.helper.MathHelpers;

public class BoxCookTickAction
implements ITickAction<BlockEntitySpiritFurnace> {
    public static final Map<Class<? extends LivingEntity>, List<WeightedItemStack>> MOBDROP_OVERRIDES = Maps.newHashMap();
    public static final Map<UUID, List<WeightedItemStack>> PLAYERDROP_OVERRIDES_INNER = Maps.newHashMap();
    public static final ItemStack[] PLAYERDROP_RANDOM;

    public static ItemStack withName(ItemStack itemStack, Component name) {
        itemStack.set(DataComponents.CUSTOM_NAME, (Object)name);
        return itemStack;
    }

    public static void overrideMobDrop(Class<? extends LivingEntity> entity, Set<WeightedItemStack> drops) {
        MOBDROP_OVERRIDES.put(entity, WeightedItemStack.createWeightedList(drops));
    }

    public static void overridePlayerDropInner(String playerId, ItemStack drop) {
        PLAYERDROP_OVERRIDES_INNER.put(UUID.fromString(playerId), WeightedItemStack.createWeightedList((Set)Sets.newHashSet((Object[])new WeightedItemStack[]{new WeightedItemStack(drop, 1)})));
    }

    @Override
    public boolean canTick(BlockEntitySpiritFurnace tile, ItemStack itemStack, int slot, int tick) {
        if (!tile.isForceHalt() && !tile.isCaughtError() && tile.canWork() && tile.getTank().getFluidAmount() >= this.getRequiredMb(tile, 0) && !this.getCookStack(tile).isEmpty() && tile.getTileWorkingMetadata().canConsume(this.getCookStack(tile), tile.getLevel())) {
            for (int slotId : tile.getProduceSlots()) {
                ItemStack production = tile.getInventory().getItem(slotId);
                if (production != null && production.getCount() >= production.getMaxStackSize()) continue;
                return tile.isSizeValidForEntity();
            }
        }
        return false;
    }

    protected ItemStack getCookStack(BlockEntitySpiritFurnace tile) {
        return tile.getInventory().getItem(tile.getConsumeSlot());
    }

    protected ItemStack getPlayerSkull(UUID playerId) {
        ItemStack itemStack = new ItemStack((ItemLike)Items.PLAYER_HEAD);
        try {
            Optional optionalGameProfile = (Optional)SkullBlockEntity.fetchGameProfile((UUID)playerId).get(1L, TimeUnit.SECONDS);
            optionalGameProfile.ifPresent(gameProfile -> itemStack.set(DataComponents.PROFILE, (Object)new ResolvableProfile(gameProfile)));
        }
        catch (InterruptedException | NullPointerException | ExecutionException | TimeoutException e) {
            e.printStackTrace();
        }
        return itemStack;
    }

    protected ItemStack getPlayerDeterminedDrop(String playerId) {
        return PLAYERDROP_RANDOM[Math.abs(playerId.hashCode() % PLAYERDROP_RANDOM.length)].copy();
    }

    protected void doNextDrop(BlockEntitySpiritFurnace tile) {
        Entity entityRaw = tile.getEntity();
        if (entityRaw instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)entityRaw;
            Level world = tile.getLevel();
            SoundEvent deathSound = entity.getDeathSound();
            if (BlockSpiritFurnaceConfig.mobDeathSounds && deathSound != null) {
                BlockPos pos = tile.getBlockPos();
                world.playSound(null, pos, deathSound, entity.getSoundSource(), 0.5f + world.random.nextFloat() * 0.2f, 1.0f);
            }
            if (tile.isPlayer()) {
                WeightedItemStack weightedItemStack;
                ItemStack drop;
                UUID playerUuid = UUID.fromString(tile.getPlayerId());
                LinkedList possibleDrops = Lists.newLinkedList();
                possibleDrops.add(new WeightedItemStack(this.getPlayerDeterminedDrop(tile.getPlayerId()), 1));
                List<WeightedItemStack> overridenDrops = PLAYERDROP_OVERRIDES_INNER.get(playerUuid);
                if (overridenDrops == null) {
                    Map<String, List<WeightedItemStack>> playerDropOverrides = this.getPlayerDropOverrides();
                    overridenDrops = playerDropOverrides.get(playerUuid.toString());
                }
                if (overridenDrops != null) {
                    possibleDrops.addAll(overridenDrops);
                }
                if (!"Forgotten Player".equals(tile.getPlayerName())) {
                    possibleDrops.add(new WeightedItemStack(this.getPlayerSkull(UUID.fromString(tile.getPlayerId())), 1));
                }
                if (!(drop = (weightedItemStack = WeightedItemStack.getRandomWeightedItemStack((List)possibleDrops, (RandomSource)world.random)).getItemStackWithRandomizedSize(world.random)).isEmpty()) {
                    tile.onItemDrop(drop);
                }
            } else if (MOBDROP_OVERRIDES.containsKey(entity.getClass())) {
                List<WeightedItemStack> possibleDrops = MOBDROP_OVERRIDES.get(entity.getClass());
                WeightedItemStack weightedItemStack = WeightedItemStack.getRandomWeightedItemStack(possibleDrops, (RandomSource)world.random);
                ItemStack drop = weightedItemStack.getItemStackWithRandomizedSize(world.random);
                if (!drop.isEmpty()) {
                    tile.onItemDrop(drop);
                }
            } else {
                Map<EntityType<?>, ResourceLocation> mobDropTablesOverrides = this.getMobDropTablesOverrides();
                ResourceKey deathLootTable = mobDropTablesOverrides.containsKey(entity.getType()) ? ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)mobDropTablesOverrides.get(entity.getType())) : (ResourceKey)entity.getLootTable().orElse(null);
                if (deathLootTable != null) {
                    LootTable loottable = tile.getLevel().getServer().reloadableRegistries().getLootTable(deathLootTable);
                    FakePlayer killerEntity = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)tile.getLevel()));
                    LootParams.Builder lootcontext$builder = new LootParams.Builder((ServerLevel)tile.getLevel()).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ORIGIN, (Object)new Vec3((double)tile.getBlockPos().getX(), (double)tile.getBlockPos().getY(), (double)tile.getBlockPos().getZ())).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)killerEntity).withParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)killerEntity).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)killerEntity.damageSources().generic()).withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)killerEntity);
                    for (ItemStack itemstack : loottable.getRandomItems(lootcontext$builder.create(LootContextParamSets.ENTITY))) {
                        tile.onItemDrop(itemstack);
                    }
                }
            }
        }
    }

    private Map<String, List<WeightedItemStack>> getPlayerDropOverrides() {
        IdentityHashMap map = Maps.newIdentityHashMap();
        for (String line : BlockSpiritFurnaceConfig.playerDrops) {
            String[] split = line.split("\\|");
            if (split.length != 2) {
                throw new IllegalArgumentException("Invalid line '" + line + "' found for a Spirit Furnace player drop config.");
            }
            try {
                String playerId = split[0];
                boolean validId = true;
                try {
                    UUID.fromString(playerId);
                }
                catch (IllegalArgumentException e) {
                    validId = false;
                }
                if (!validId) {
                    EvilCraft.clog("Invalid line '" + line + "' found for a Spirit Furnace player drop config: " + split[0] + " does not refer to a valid player UUID; skipping.");
                    continue;
                }
                try {
                    ItemStack itemStack = IModHelpers.get().getItemStackHelpers().parseItemStack(split[1]);
                    map.put(playerId, Lists.newArrayList((Object[])new WeightedItemStack[]{new WeightedItemStack(itemStack, 1)}));
                }
                catch (IllegalArgumentException e) {
                    EvilCraft.clog("Invalid item '" + split[1] + "' in a Spirit Furnace player drop config; skipping:" + e.getMessage(), org.apache.logging.log4j.Level.ERROR);
                }
            }
            catch (NumberFormatException e) {
                EvilCraft.clog("Invalid line '" + line + "' found for a Spirit Furnace player drop config: " + split[0] + " is not a number; skipping.");
            }
        }
        return map;
    }

    private Map<EntityType<?>, ResourceLocation> getMobDropTablesOverrides() {
        IdentityHashMap map = Maps.newIdentityHashMap();
        for (String line : BlockSpiritFurnaceConfig.mobDrops) {
            String[] split = line.split("\\|");
            if (split.length != 2) {
                throw new IllegalArgumentException("Invalid line '" + line + "' found for a Spirit Furnace mob drop config.");
            }
            ResourceLocation entityName = ResourceLocation.parse((String)split[0]);
            if (!BuiltInRegistries.ENTITY_TYPE.containsKey(entityName)) {
                EvilCraft.clog("Invalid line '" + line + "' found for a Spirit Furnace mob drop config: " + split[0] + " does not refer to a valid entity name; skipping.");
                continue;
            }
            ResourceLocation resourceLocation = ResourceLocation.parse((String)split[1]);
            map.put((EntityType)BuiltInRegistries.ENTITY_TYPE.getValue(entityName), resourceLocation);
        }
        return map;
    }

    protected int getRequiredMb(BlockEntitySpiritFurnace tile, int tick) {
        int baseUsage = tile.isPlayer() ? BlockSpiritFurnaceConfig.playerMBPerTick : (tile.getEntity() != null && !tile.getEntity().canTeleport(tile.getLevel(), tile.getLevel()) ? BlockSpiritFurnaceConfig.bossMBPerTick : BlockSpiritFurnaceConfig.mBPerTick);
        MutableDouble drain = new MutableDouble((double)baseUsage);
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableDouble>(drain, BlockEntitySpiritFurnace.UPGRADEEVENT_BLOODUSAGE));
        return MathHelpers.factorToBursts(drain.getValue(), tick);
    }

    @Override
    public void onTick(BlockEntitySpiritFurnace tile, ItemStack itemStack, int slot, int tick) {
        tile.getTank().drain(this.getRequiredMb(tile, tick), IFluidHandler.FluidAction.EXECUTE);
        if ((float)tick >= this.getRequiredTicks(tile, slot, tick)) {
            this.doNextDrop(tile);
        }
    }

    @Override
    public float getRequiredTicks(BlockEntitySpiritFurnace tile, int slot, int tick) {
        int requiredTicksBase;
        Entity entity = tile.getEntity();
        if (entity == null) {
            requiredTicksBase = BlockSpiritFurnaceConfig.requiredTicksPerHp;
        } else {
            try {
                LivingEntity livingEntity = (LivingEntity)entity;
                requiredTicksBase = (int)((livingEntity.getHealth() + (float)livingEntity.getArmorValue()) * (float)BlockSpiritFurnaceConfig.requiredTicksPerHp);
            }
            catch (RuntimeException e) {
                requiredTicksBase = 40 * BlockSpiritFurnaceConfig.requiredTicksPerHp;
            }
        }
        MutableDouble duration = new MutableDouble((double)requiredTicksBase);
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableDouble>(duration, BlockEntitySpiritFurnace.UPGRADEEVENT_SPEED));
        return (int)duration.getValue().doubleValue();
    }

    static {
        if (BlockSpiritFurnaceConfig.villagerDropEmeraldChance > 0) {
            BoxCookTickAction.overrideMobDrop(Villager.class, Sets.newHashSet((Object[])new WeightedItemStack[]{new WeightedItemStack(new ItemStack((ItemLike)Items.EMERALD), 1), new WeightedItemStack(ItemStack.EMPTY, BlockSpiritFurnaceConfig.villagerDropEmeraldChance - 1)}));
        }
        BoxCookTickAction.overrideMobDrop(WitherBoss.class, Sets.newHashSet((Object[])new WeightedItemStack[]{new WeightedItemStack(new ItemStack((ItemLike)Items.NETHER_STAR), 1)}));
        BoxCookTickAction.overridePlayerDropInner("068d4de0-3a75-4c6a-9f01-8c37e16a394c", new ItemStack((ItemLike)Items.EMERALD));
        BoxCookTickAction.overridePlayerDropInner("e1dc75c6-dcf9-4e0c-8fbf-9c6e5e44527c", new ItemStack((ItemLike)Items.WOODEN_SWORD));
        BoxCookTickAction.overridePlayerDropInner("777e7aa3-9373-4511-8d75-f99d23ebe252", BoxCookTickAction.withName(new ItemStack((ItemLike)Items.BROWN_DYE), (Component)Component.literal((String)"Lekkere Stront")));
        BoxCookTickAction.overridePlayerDropInner("3e13f558-fb72-4949-a842-07879924bc49", new ItemStack((ItemLike)Items.QUARTZ));
        BoxCookTickAction.overridePlayerDropInner("b5c31e33-8224-4f96-a4bf-73721be9d2ec", new ItemStack((ItemLike)Blocks.COBBLESTONE));
        BoxCookTickAction.overridePlayerDropInner("b2faeaab-fc87-4f91-98d3-836024f268ae", BoxCookTickAction.withName(new ItemStack((ItemLike)Blocks.FURNACE), (Component)Component.literal((String)"Fuurnas")));
        BoxCookTickAction.overridePlayerDropInner("069a79f4-44e9-4726-a5be-fca90e38aaf5", new ItemStack((ItemLike)Items.ENCHANTED_GOLDEN_APPLE));
        BoxCookTickAction.overridePlayerDropInner("853c80ef-3c37-49fd-aa49-938b674adae6", BoxCookTickAction.withName(new ItemStack((ItemLike)Items.SHEEP_SPAWN_EGG), (Component)Component.literal((String)"jeb_")));
        BoxCookTickAction.overridePlayerDropInner("61699b2e-d327-4a01-9f1e-0ea8c3f06bc6", BoxCookTickAction.withName(new ItemStack((ItemLike)Items.SHEEP_SPAWN_EGG), (Component)Component.literal((String)"Dinnerbone")));
        BoxCookTickAction.overridePlayerDropInner("bbb87dbe-690f-4205-bdc5-72ffb8ebc29d", BoxCookTickAction.withName(new ItemStack((ItemLike)Blocks.COBBLESTONE, 45), (Component)Component.literal((String)"direwolf20")));
        BoxCookTickAction.overridePlayerDropInner("0b7509f0-2458-4160-9ce1-2772b9a45ac2", new ItemStack((ItemLike)Items.PORKCHOP));
        PLAYERDROP_RANDOM = new ItemStack[]{new ItemStack((ItemLike)Items.BOOK), new ItemStack((ItemLike)Items.BLAZE_POWDER), new ItemStack((ItemLike)Items.QUARTZ), new ItemStack((ItemLike)Items.CHAINMAIL_CHESTPLATE), new ItemStack((ItemLike)Items.FERMENTED_SPIDER_EYE), new ItemStack((ItemLike)Items.GLASS_BOTTLE), new ItemStack((ItemLike)Items.ITEM_FRAME), new ItemStack((ItemLike)Items.MINECART), new ItemStack((ItemLike)Items.SHEARS), new ItemStack((ItemLike)Items.SUGAR_CANE), new ItemStack((ItemLike)Items.PUMPKIN_PIE), new ItemStack((ItemLike)Items.MAGMA_CREAM), new ItemStack((ItemLike)Items.SADDLE), new ItemStack((ItemLike)Items.GLISTERING_MELON_SLICE), new ItemStack((ItemLike)Items.IRON_HOE), new ItemStack((ItemLike)Items.CARROT_ON_A_STICK), new ItemStack((ItemLike)Items.REDSTONE), new ItemStack((ItemLike)Blocks.COAL_BLOCK), new ItemStack((ItemLike)Blocks.LAPIS_BLOCK), new ItemStack((ItemLike)Blocks.SOUL_SAND), new ItemStack((ItemLike)Blocks.GRAVEL), new ItemStack((ItemLike)Blocks.HOPPER)};
    }
}

