/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.EnchantTableRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.evilcraft.blockentity.BlockEntityPurifier;
import org.cyclops.evilcraft.blockentity.tickaction.purifier.DisenchantPurifyAction;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class RenderBlockEntityPurifier
implements BlockEntityRenderer<BlockEntityPurifier> {
    public static final Material TEXTURE_BLOOK = new Material(Sheets.CHEST_SHEET, ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"entity/blook"));
    private final BookModel enchantmentBook;

    public RenderBlockEntityPurifier(BlockEntityRendererProvider.Context context) {
        this.enchantmentBook = new BookModel(context.bakeLayer(ModelLayers.BOOK));
    }

    public void render(BlockEntityPurifier tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, Vec3 cameraPos) {
        ItemStack additionalItem = tile.getAdditionalItem();
        if (!additionalItem.isEmpty()) {
            if (additionalItem.getItem() == DisenchantPurifyAction.ALLOWED_BOOK.get() || additionalItem.getItem() == Items.ENCHANTED_BOOK) {
                this.renderBook(tile, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, additionalItem, partialTicks);
            } else {
                this.renderAdditionalItem(tile, matrixStackIn, bufferIn, additionalItem, partialTicks);
            }
        }
        matrixStackIn.pushPose();
        matrixStackIn.translate(-0.5f, -0.5f, -0.5f);
        if (!tile.getPurifyItem().isEmpty()) {
            this.renderItem(matrixStackIn, bufferIn, tile.getPurifyItem(), tile.getRandomRotation(), tile.getLevel());
        }
        matrixStackIn.popPose();
        FluidStack fluid = tile.getTank().getFluid();
        IModHelpersNeoForge.get().getRenderHelpers().renderFluidContext(fluid, matrixStackIn, () -> {
            float height = (float)((double)fluid.getAmount() * 0.7 / (double)tile.getTank().getCapacity() + 0.23 + 0.01);
            int brightness = Math.max(combinedLightIn, fluid.getFluid().getFluidType().getLightLevel(fluid));
            int l2 = brightness >> 16 & 0xFFFF;
            int i3 = brightness & 0xFFFF;
            TextureAtlasSprite icon = IModHelpersNeoForge.get().getRenderHelpers().getFluidIcon(fluid, Direction.UP);
            IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
            Triple color = IModHelpers.get().getBaseHelpers().intToRGB(renderProperties.getTintColor(fluid.getFluid().defaultFluidState(), (BlockAndTintGetter)tile.getLevel(), tile.getBlockPos()));
            VertexConsumer vb = bufferIn.getBuffer(RenderType.text((ResourceLocation)icon.atlasLocation()));
            Matrix4f matrix = matrixStackIn.last().pose();
            vb.addVertex(matrix, 0.0625f, height, 0.0625f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU0(), icon.getV1()).setUv2(l2, i3);
            vb.addVertex(matrix, 0.0625f, height, 0.9375f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU0(), icon.getV0()).setUv2(l2, i3);
            vb.addVertex(matrix, 0.9375f, height, 0.9375f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU1(), icon.getV0()).setUv2(l2, i3);
            vb.addVertex(matrix, 0.9375f, height, 0.0625f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU1(), icon.getV1()).setUv2(l2, i3);
        });
    }

    private void renderItem(PoseStack matrixStackIn, MultiBufferSource bufferIn, ItemStack itemStack, float rotation, Level level) {
        matrixStackIn.pushPose();
        if (itemStack.getItem() instanceof BlockItem) {
            matrixStackIn.translate(1.0f, 1.2f, 1.0f);
            matrixStackIn.scale(0.6f, 0.6f, 0.6f);
        } else {
            matrixStackIn.translate(1.0f, 1.2f, 1.0f);
            matrixStackIn.mulPose((Quaternionfc)Axis.XP.rotationDegrees(25.0f));
            matrixStackIn.mulPose((Quaternionfc)Axis.YP.rotationDegrees(25.0f));
            matrixStackIn.mulPose((Quaternionfc)Axis.YP.rotationDegrees(rotation));
        }
        Minecraft.getInstance().getItemRenderer().renderStatic(itemStack, ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.NO_OVERLAY, matrixStackIn, bufferIn, level, 0);
        matrixStackIn.popPose();
    }

    private void renderAdditionalItem(BlockEntityPurifier tile, PoseStack matrixStackIn, MultiBufferSource bufferIn, ItemStack itemStack, float partialTickTime) {
        float speedUp;
        matrixStackIn.pushPose();
        float tick = (float)tile.tickCount.intValue() + partialTickTime;
        matrixStackIn.translate(0.5f, 0.75f, 0.5f);
        matrixStackIn.translate(0.0f, 0.1f + Mth.sin((float)(tick * 0.1f)) * 0.01f, 0.0f);
        if (itemStack.getItem() instanceof BlockItem) {
            matrixStackIn.translate(1.0f, 0.675f, 1.0f);
        }
        for (speedUp = tile.additionalRotation2.floatValue() - tile.additionalRotationPrev.floatValue(); speedUp >= (float)Math.PI; speedUp -= (float)Math.PI * 2) {
        }
        while (speedUp < (float)(-Math.PI)) {
            speedUp += (float)Math.PI * 2;
        }
        float rotation = tile.additionalRotationPrev.floatValue() + speedUp * partialTickTime;
        matrixStackIn.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-rotation * 180.0f / (float)Math.PI));
        matrixStackIn.translate(0.0f, 0.5f, 0.0f);
        if (!(itemStack.getItem() instanceof BlockItem)) {
            matrixStackIn.mulPose((Quaternionfc)Axis.YP.rotationDegrees(25.0f));
            matrixStackIn.mulPose((Quaternionfc)Axis.YP.rotationDegrees(rotation));
        }
        Minecraft.getInstance().getItemRenderer().renderStatic(itemStack, ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.NO_OVERLAY, matrixStackIn, bufferIn, tile.getLevel(), 0);
        matrixStackIn.popPose();
    }

    private void renderBook(BlockEntityPurifier tile, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, ItemStack itemStack, float partialTickTime) {
        float speedUp;
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.5f, 0.75f, 0.5f);
        float tick = (float)tile.tickCount.intValue() + partialTickTime;
        matrixStackIn.translate(0.0f, 0.1f + Mth.sin((float)(tick * 0.1f)) * 0.01f, 0.0f);
        for (speedUp = tile.additionalRotation2.floatValue() - tile.additionalRotationPrev.floatValue(); speedUp >= (float)Math.PI; speedUp -= (float)Math.PI * 2) {
        }
        while (speedUp < (float)(-Math.PI)) {
            speedUp += (float)Math.PI * 2;
        }
        float rotation = tile.additionalRotationPrev.floatValue() + speedUp * partialTickTime;
        matrixStackIn.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-rotation * 180.0f / (float)Math.PI));
        matrixStackIn.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(80.0f));
        float f3 = Mth.lerp((float)partialTickTime, (float)tile.oFlip, (float)tile.flip);
        float f4 = Mth.frac((float)(f3 + 0.25f)) * 1.6f - 0.3f;
        float f5 = Mth.frac((float)(f3 + 0.75f)) * 1.6f - 0.3f;
        float f6 = Mth.lerp((float)partialTickTime, (float)tile.oOpen, (float)tile.open);
        this.enchantmentBook.setupAnim(rotation, Mth.clamp((float)f4, (float)0.0f, (float)1.0f), Mth.clamp((float)f5, (float)0.0f, (float)1.0f), f6);
        Material material = itemStack.getItem() == DisenchantPurifyAction.ALLOWED_BOOK.get() ? TEXTURE_BLOOK : EnchantTableRenderer.BOOK_LOCATION;
        VertexConsumer ivertexbuilder = material.buffer(bufferIn, RenderType::entitySolid);
        this.enchantmentBook.renderToBuffer(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn, -1);
        matrixStackIn.popPose();
    }
}

