/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.degradation;

import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.api.degradation.IDegradable;
import org.cyclops.evilcraft.api.degradation.IDegradationEffect;
import org.cyclops.evilcraft.api.degradation.IDegradationRegistry;

public class DegradationExecutor {
    private static final int DEFAULT_TICK_INTERVAL = 1;
    private int tickInterval = 1;
    private int currentTick = 0;
    private IDegradable degradable;

    public DegradationExecutor(IDegradable degradable) {
        this.degradable = degradable;
    }

    public boolean runRandomEffect(boolean isClientSide) {
        ++this.currentTick;
        if (this.currentTick >= this.tickInterval) {
            this.currentTick = 0;
            IDegradationEffect effect = ((IDegradationRegistry)EvilCraft._instance.getRegistryManager().getRegistry(IDegradationRegistry.class)).getRandomDegradationEffect();
            if (effect.canRun(this.degradable)) {
                if (isClientSide) {
                    effect.runClientSide(this.degradable);
                } else {
                    effect.runServerSide(this.degradable);
                }
                return true;
            }
        }
        return false;
    }

    public void read(ValueInput input) {
        this.tickInterval = (Integer)input.getInt("tickInterval").orElseThrow();
        this.currentTick = (Integer)input.getInt("currentTick").orElseThrow();
    }

    public void write(ValueOutput output) {
        output.putInt("tickInterval", this.tickInterval);
        output.putInt("currentTick", this.currentTick);
    }

    public int getTickInterval() {
        return this.tickInterval;
    }

    public void setTickInterval(int tickInterval) {
        this.tickInterval = tickInterval;
    }
}

