/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.recipe.display;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import org.cyclops.evilcraft.core.weather.WeatherType;

public record RecipeDisplayEnvironmentalAccumulator(SlotDisplay inputIngredient, WeatherType inputWeather, SlotDisplay outputItem, WeatherType outputWeather, SlotDisplay craftingStation, int duration, int cooldownTime, float processingSpeed) implements RecipeDisplay
{
    public static final MapCodec<RecipeDisplayEnvironmentalAccumulator> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SlotDisplay.CODEC.fieldOf("input_ingredient").forGetter(RecipeDisplayEnvironmentalAccumulator::inputIngredient), (App)WeatherType.CODEC.fieldOf("input_weather").forGetter(RecipeDisplayEnvironmentalAccumulator::inputWeather), (App)SlotDisplay.CODEC.fieldOf("output_ingredient").forGetter(RecipeDisplayEnvironmentalAccumulator::outputItem), (App)WeatherType.CODEC.fieldOf("output_weather").forGetter(RecipeDisplayEnvironmentalAccumulator::outputWeather), (App)SlotDisplay.CODEC.fieldOf("crafting_station").forGetter(RecipeDisplayEnvironmentalAccumulator::craftingStation), (App)Codec.INT.fieldOf("duration").forGetter(RecipeDisplayEnvironmentalAccumulator::duration), (App)Codec.INT.fieldOf("cooldown_time").forGetter(RecipeDisplayEnvironmentalAccumulator::cooldownTime), (App)Codec.FLOAT.fieldOf("processing_speed").forGetter(RecipeDisplayEnvironmentalAccumulator::processingSpeed)).apply((Applicative)instance, RecipeDisplayEnvironmentalAccumulator::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, RecipeDisplayEnvironmentalAccumulator> STREAM_CODEC = StreamCodec.composite((StreamCodec)SlotDisplay.STREAM_CODEC, RecipeDisplayEnvironmentalAccumulator::inputIngredient, WeatherType.STREAM_CODEC, RecipeDisplayEnvironmentalAccumulator::inputWeather, (StreamCodec)SlotDisplay.STREAM_CODEC, RecipeDisplayEnvironmentalAccumulator::outputItem, WeatherType.STREAM_CODEC, RecipeDisplayEnvironmentalAccumulator::outputWeather, (StreamCodec)SlotDisplay.STREAM_CODEC, RecipeDisplayEnvironmentalAccumulator::craftingStation, (StreamCodec)ByteBufCodecs.VAR_INT, RecipeDisplayEnvironmentalAccumulator::duration, (StreamCodec)ByteBufCodecs.VAR_INT, RecipeDisplayEnvironmentalAccumulator::cooldownTime, (StreamCodec)ByteBufCodecs.FLOAT, RecipeDisplayEnvironmentalAccumulator::processingSpeed, RecipeDisplayEnvironmentalAccumulator::new);
    public static final RecipeDisplay.Type<RecipeDisplayEnvironmentalAccumulator> TYPE = new RecipeDisplay.Type(MAP_CODEC, STREAM_CODEC);

    public SlotDisplay result() {
        return this.outputItem();
    }

    public RecipeDisplay.Type<? extends RecipeDisplay> type() {
        return TYPE;
    }

    public boolean isEnabled(FeatureFlagSet featureFlagSet) {
        return this.inputIngredient.isEnabled(featureFlagSet) && this.outputItem().isEnabled(featureFlagSet) && super.isEnabled(featureFlagSet);
    }
}

