/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.effect;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.cyclops.cyclopscore.client.particle.ParticleBlurData;
import org.cyclops.evilcraft.ExtendedDamageSources;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.entity.effect.EntityAntiVengeanceBeam;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpirit;

public class EntityAttackVengeanceBeam
extends EntityAntiVengeanceBeam {
    public EntityAttackVengeanceBeam(EntityType<? extends EntityAttackVengeanceBeam> type, Level world) {
        super(type, world);
    }

    public EntityAttackVengeanceBeam(Level world, LivingEntity entity) {
        super((EntityType<? extends EntityAntiVengeanceBeam>)((EntityType)RegistryEntries.ENTITY_ATTACK_VENGEANCE_BEAM.get()), world, entity);
        this.setOwner((Entity)entity);
    }

    @Override
    protected void showNewBlurParticle() {
        float scale = 0.6f - this.random.nextFloat() * 0.3f;
        float red = this.random.nextFloat() * 0.03f + 0.1f;
        float green = this.random.nextFloat() * 0.03f;
        float blue = this.random.nextFloat() * 0.05f;
        float ageMultiplier = (float)(this.random.nextDouble() * 4.5 + 4.0);
        Vec3 motion = this.getDeltaMovement();
        this.level().addParticle((ParticleOptions)new ParticleBlurData(red, green, blue, scale, ageMultiplier), this.getX(), this.getY(), this.getZ(), this.deriveMotion(motion.x), this.deriveMotion(motion.y), this.deriveMotion(motion.z));
    }

    private double deriveMotion(double motion) {
        return motion * 1.0 + (0.02 - this.random.nextDouble() * 0.04);
    }

    @Override
    protected void applyHitEffect(Entity entity) {
        if (entity instanceof EntityVengeanceSpirit) {
            if (this.getOwner() instanceof LivingEntity) {
                entity.hurt(ExtendedDamageSources.vengeanceBeam((LivingEntity)this.getOwner()), 1.0f);
                ((EntityVengeanceSpirit)entity).setRemainingLife(((EntityVengeanceSpirit)entity).getRemainingLife() + 10);
            }
        } else if (entity instanceof LivingEntity) {
            LivingEntity entityLiving = (LivingEntity)entity;
            entityLiving.removeAllEffects();
        }
    }
}

