/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.inventory.container;

import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.cyclops.cyclopscore.helper.EntityHelpers;
import org.cyclops.cyclopscore.inventory.slot.SlotFluidContainer;
import org.cyclops.cyclopscore.inventory.slot.SlotRemoveOnly;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.api.gameevent.BloodInfuserRemoveEvent;
import org.cyclops.evilcraft.blockentity.BlockEntityBloodInfuser;
import org.cyclops.evilcraft.core.blockentity.BlockEntityWorking;
import org.cyclops.evilcraft.core.inventory.container.ContainerTileWorking;
import org.cyclops.evilcraft.core.inventory.slot.SlotWorking;

public class ContainerBloodInfuser
extends ContainerTileWorking<BlockEntityBloodInfuser> {
    private static final int INVENTORY_OFFSET_X = 8;
    private static final int INVENTORY_OFFSET_Y = 84;
    public static final int SLOT_CONTAINER_X = 8;
    public static final int SLOT_CONTAINER_Y = 36;
    public static final int SLOT_INFUSE_X = 79;
    public static final int SLOT_INFUSE_Y = 36;
    public static final int SLOT_INFUSE_RESULT_X = 133;
    public static final int SLOT_INFUSE_RESULT_Y = 36;
    private static final int UPGRADE_INVENTORY_OFFSET_X = -22;
    private static final int UPGRADE_INVENTORY_OFFSET_Y = 6;

    public ContainerBloodInfuser(int id, Inventory playerInventory) {
        this(id, playerInventory, (Container)new SimpleContainer(7), Optional.empty());
    }

    public ContainerBloodInfuser(int id, Inventory playerInventory, Container inventory, final Optional<BlockEntityBloodInfuser> tileSupplier) {
        super((MenuType)RegistryEntries.CONTAINER_BLOOD_INFUSER.get(), id, playerInventory, inventory, tileSupplier, BlockEntityBloodInfuser.TICKERS, 4);
        this.addSlot((Slot)new SlotFluidContainer(inventory, 0, 8, 36, (Fluid)RegistryEntries.FLUID_BLOOD.get()));
        this.addSlot(new SlotWorking<BlockEntityBloodInfuser>(1, 79, 36, this, playerInventory.player.level()));
        this.addSlot((Slot)new SlotRemoveOnly(inventory, 2, 133, 36){

            public void onTake(Player thePlayer, ItemStack stack) {
                tileSupplier.ifPresent(tile -> {
                    EntityHelpers.spawnXpAtPlayer((Level)ContainerBloodInfuser.this.player.level(), (Player)ContainerBloodInfuser.this.player, (int)((int)Math.floor(tile.getXp())));
                    tile.resetXp();
                    NeoForge.EVENT_BUS.post((Event)new BloodInfuserRemoveEvent(ContainerBloodInfuser.this.player, stack));
                });
                super.onTake(thePlayer, stack);
            }
        });
        this.addUpgradeInventory(-22, 6, 3);
        this.addPlayerInventory(playerInventory, 8, 84);
    }

    @Override
    public BlockEntityWorking.Metadata getTileWorkingMetadata() {
        return BlockEntityBloodInfuser.METADATA;
    }
}

