/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraftcompat.modcompat.jei.spiritreanimator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockSpiritReanimatorConfig;

public class SpiritReanimatorRecipeJEI {
    private final FluidStack inputFluid = new FluidStack(RegistryEntries.FLUID_BLOOD, BlockSpiritReanimatorConfig.mBPerTick * BlockSpiritReanimatorConfig.requiredTicks);
    private final ItemStack inputItem;
    private final ItemStack outputItem;
    private final int duration;

    public SpiritReanimatorRecipeJEI(EntityType<?> entityType) {
        this.inputItem = SpiritReanimatorRecipeJEI.getBox(entityType);
        this.outputItem = new ItemStack((ItemLike)SpawnEggItem.byId(entityType));
        this.duration = BlockSpiritReanimatorConfig.requiredTicks;
    }

    public static ItemStack getBox(EntityType<?> entityType) {
        ItemStack stack = new ItemStack((ItemLike)RegistryEntries.BLOCK_BOX_OF_ETERNAL_CLOSURE.get());
        CompoundTag spiritTag = new CompoundTag();
        spiritTag.putString("innerEntity", BuiltInRegistries.ENTITY_TYPE.getKey(entityType).toString());
        stack.set(RegistryEntries.COMPONENT_BOX_SPIRIT_DATA, (Object)spiritTag);
        return stack;
    }

    public FluidStack getInputFluid() {
        return this.inputFluid;
    }

    public ItemStack getInputItem() {
        return this.inputItem;
    }

    public ItemStack getOutputItem() {
        return this.outputItem;
    }

    public int getDuration() {
        return this.duration;
    }

    public static List<SpiritReanimatorRecipeJEI> getAllRecipes() {
        ArrayList recipes = Lists.newArrayList();
        for (EntityType entityType : BuiltInRegistries.ENTITY_TYPE) {
            if (SpawnEggItem.byId((EntityType)entityType) == null) continue;
            recipes.add(new SpiritReanimatorRecipeJEI(entityType));
        }
        return recipes;
    }
}

