/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.degradation.effect;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import org.cyclops.cyclopscore.helper.EntityHelpers;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.evilcraft.api.degradation.IDegradable;
import org.cyclops.evilcraft.core.config.extendedconfig.DegradationEffectConfig;
import org.cyclops.evilcraft.core.degradation.StochasticDegradationEffect;

public class MobSpawnDegradation
extends StochasticDegradationEffect {
    private static final double CHANCE = 0.01;

    public MobSpawnDegradation(DegradationEffectConfig eConfig) {
        super(eConfig, 0.01);
    }

    @Override
    public void runClientSide(IDegradable degradable) {
    }

    @Override
    public void runServerSide(IDegradable degradable) {
        Mob entityliving;
        ServerLevel world = (ServerLevel)degradable.getDegradationWorld();
        BlockPos spawn = LocationHelpers.getRandomPointInSphere((BlockPos)degradable.getLocation(), (int)degradable.getRadius());
        float x = (float)spawn.getX() + 0.5f;
        float y = spawn.getY();
        float z = (float)spawn.getZ() + 0.5f;
        Optional spawnlistentry = ((Biome)world.getBiome(spawn).value()).getMobSettings().getMobs(MobCategory.MONSTER).getRandom(world.random);
        try {
            entityliving = (Mob)((MobSpawnSettings.SpawnerData)spawnlistentry.get()).type.create((Level)world);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        entityliving.moveTo((double)x, (double)y, (double)z, world.random.nextFloat() * 360.0f, 0.0f);
        EntityHelpers.spawnEntity((ServerLevelAccessor)world, (Mob)entityliving, (MobSpawnType)MobSpawnType.MOB_SUMMONED);
    }
}

