/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraftcompat.network.packet;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.evilcraftcompat.modcompat.jei.JeiCompatLoader;
import org.cyclops.evilcraftcompat.modcompat.jei.spiritfurnace.SpiritFurnaceRecipeJEI;

public class JeiSpiritFurnaceRecipePacket
extends PacketCodec {
    public static final CustomPacketPayload.Type<JeiSpiritFurnaceRecipePacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"evilcraftcompat", (String)"jei_spirit_furnace_recipe"));
    public static final StreamCodec<RegistryFriendlyByteBuf, JeiSpiritFurnaceRecipePacket> CODEC = JeiSpiritFurnaceRecipePacket.getCodec(JeiSpiritFurnaceRecipePacket::new);
    private SpiritFurnaceRecipeJEI recipe;
    private int totalCount;

    public JeiSpiritFurnaceRecipePacket() {
        super(ID);
    }

    public JeiSpiritFurnaceRecipePacket(SpiritFurnaceRecipeJEI recipe, int totalCount) {
        this();
        this.recipe = recipe;
        this.totalCount = totalCount;
    }

    public boolean isAsync() {
        return false;
    }

    public void encode(RegistryFriendlyByteBuf output) {
        super.encode(output);
        SpiritFurnaceRecipeJEI.encode(this.recipe, output);
        output.writeInt(this.totalCount);
    }

    public void decode(RegistryFriendlyByteBuf input) {
        super.decode(input);
        this.recipe = SpiritFurnaceRecipeJEI.decode(input);
        this.totalCount = input.readInt();
    }

    public void actionClient(Level world, Player player) {
        JeiCompatLoader.receiveSpiritFurnaceRecipeOnClient(this.recipe, this.totalCount);
    }

    public void actionServer(Level world, ServerPlayer player) {
    }
}

