/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.capabilities.Capabilities;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.capability.registrar.BlockEntityCapabilityRegistrar;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.fluid.WorldSharedTank;
import org.cyclops.evilcraft.core.fluid.WorldSharedTankCache;

public class BlockEntityEntangledChalice
extends CyclopsBlockEntity {
    public static final int BASE_CAPACITY = 4000;
    private final WorldSharedTank tank = new WorldSharedTank(4000);

    public BlockEntityEntangledChalice(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.BLOCK_ENTITY_ENTANGLED_CHALICE.get(), blockPos, blockState);
    }

    public WorldSharedTank getTank() {
        return this.tank;
    }

    public double getFillRatio() {
        int prev = this.getTank().getPreviousAmount();
        float alpha = (float)WorldSharedTankCache.getInstance().getTickOffset() / 10.0f;
        double interpolatedAmount = (float)prev * (1.0f - alpha) + (float)this.getTank().getFluidAmount() * alpha;
        return Math.min(1.0, interpolatedAmount / (double)this.getTank().getCapacity());
    }

    public String getWorldTankId() {
        return this.getTank().getTankID();
    }

    public void setWorldTankId(String tankId) {
        this.getTank().setTankID(tankId);
    }

    public void read(ValueInput input) {
        super.read(input);
        this.tank.deserialize(input, "tank");
    }

    public void saveAdditional(ValueOutput output) {
        this.tank.serialize(output, "tank");
        super.saveAdditional(output);
    }

    public static class TickerServer
    extends BlockEntityTickerDelayed<BlockEntityEntangledChalice> {
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntityEntangledChalice blockEntity) {
            super.update(level, pos, blockState, (BlockEntity)blockEntity);
            blockEntity.getTank().resetPreviousFluid();
        }
    }

    public static class CapabilityRegistrar
    extends BlockEntityCapabilityRegistrar<BlockEntityEntangledChalice> {
        public CapabilityRegistrar(Supplier<BlockEntityType<? extends BlockEntityEntangledChalice>> blockEntityType) {
            super(blockEntityType);
        }

        public void populate() {
            this.add(Capabilities.FluidHandler.BLOCK, (blockEntity, direction) -> blockEntity.getTank());
        }
    }
}

