/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AtomicLongMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.model.data.ModelData;
import org.cyclops.cyclopscore.client.model.DynamicItemAndBlockModel;
import org.cyclops.cyclopscore.helper.ModelHelpers;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.core.broom.BroomParts;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ModelBroomBaked
extends DynamicItemAndBlockModel {
    protected static final ItemTransforms PERSPECTIVE_TRANSFORMS = ModelHelpers.modifyDefaultTransforms((Map)ImmutableMap.of((Object)ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, (Object)new ItemTransform((Vector3fc)new Vector3f(90.0f, 180.0f, 90.0f), (Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f)), (Object)ItemDisplayContext.THIRD_PERSON_LEFT_HAND, (Object)new ItemTransform((Vector3fc)new Vector3f(90.0f, 180.0f, 90.0f), (Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f)), (Object)ItemDisplayContext.FIRST_PERSON_LEFT_HAND, (Object)new ItemTransform((Vector3fc)new Vector3f(10.0f, 190.0f, 100.0f), (Vector3fc)new Vector3f(0.25f, -0.025f, 0.0f), (Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f)), (Object)ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, (Object)new ItemTransform((Vector3fc)new Vector3f(10.0f, 190.0f, 100.0f), (Vector3fc)new Vector3f(0.25f, -0.025f, 0.0f), (Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f))));
    private final Map<IBroomPart, BlockStateModel> broomPartModels;
    private final RandomSource rand = RandomSource.create();

    public ModelBroomBaked(Map<IBroomPart, BlockStateModel> broomPartModels) {
        super(true, false);
        this.broomPartModels = broomPartModels;
    }

    public List<BakedQuad> getGeneralQuads() {
        return Collections.emptyList();
    }

    public List<BakedQuad> handleBlockState(BlockAndTintGetter level, BlockPos pos, BlockState state, Direction side, RandomSource rand, ModelData extraData, ChunkSectionLayer renderType) {
        throw new UnsupportedOperationException();
    }

    public ModelData getModelData(BlockAndTintGetter world, BlockPos pos, BlockState state, ModelData tileData) {
        return null;
    }

    public List<ChunkSectionLayer> getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return List.of();
    }

    public boolean usesBlockLight() {
        return true;
    }

    public TextureAtlasSprite particleIcon() {
        return null;
    }

    public List<BakedQuad> handleItemState(@javax.annotation.Nullable ItemStack itemStack, @javax.annotation.Nullable Level world, @javax.annotation.Nullable LivingEntity entity) {
        LinkedList quads = Lists.newLinkedList();
        IBroomPart rod = null;
        Collection<IBroomPart> parts = BroomParts.REGISTRY.getBroomParts(itemStack);
        for (IBroomPart part : parts) {
            if (part.getType() != IBroomPart.BroomPartType.ROD || rod != null) continue;
            rod = part;
        }
        AtomicLongMap partTypeOccurences = AtomicLongMap.create();
        for (IBroomPart part : parts) {
            BlockStateModel model = this.broomPartModels.get(part);
            if (model == null) continue;
            for (BlockModelPart blockModelPart : model.collectParts(this.rand)) {
                List originalQuads = blockModelPart.getQuads(null);
                int typeIndex = (int)partTypeOccurences.getAndIncrement((Object)part.getType());
                float offset = part.getType().getOffsetter().getOffset(rod.getLength(), part.getLength(), typeIndex);
                int color = part.getModelColor();
                quads.addAll(this.offsetAndColor(originalQuads, offset, color));
            }
        }
        return quads;
    }

    private Collection<? extends BakedQuad> offsetAndColor(List<BakedQuad> quads, float offset, int color) {
        ArrayList offsetQuads = Lists.newArrayListWithExpectedSize((int)quads.size());
        for (BakedQuad quad : quads) {
            int[] vertexData = Arrays.copyOf(quad.vertices(), quad.vertices().length);
            for (int i = 0; i < vertexData.length / 8; ++i) {
                float originalZ = Float.intBitsToFloat(vertexData[i * 8 + 2]);
                vertexData[i * 8 + 2] = Float.floatToIntBits(originalZ += offset);
                vertexData[i * 8 + 3] = color;
            }
            offsetQuads.add(new BakedQuad(vertexData, quad.tintIndex(), quad.direction(), quad.sprite(), false, quad.lightEmission(), quad.hasAmbientOcclusion()));
        }
        return offsetQuads;
    }

    public UnbakedModel wrapped() {
        return null;
    }

    @Nullable
    public ResolvedModel parent() {
        return null;
    }

    public ItemTransforms getTopTransforms() {
        return PERSPECTIVE_TRANSFORMS;
    }

    public RandomSource getRand() {
        return this.rand;
    }

    public String toString() {
        return "BroomModelBaked(rand=" + String.valueOf(this.getRand()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelBroomBaked)) {
            return false;
        }
        ModelBroomBaked other = (ModelBroomBaked)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        RandomSource this$rand = this.getRand();
        RandomSource other$rand = other.getRand();
        return !(this$rand == null ? other$rand != null : !this$rand.equals(other$rand));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModelBroomBaked;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RandomSource $rand = this.getRand();
        result = result * 59 + ($rand == null ? 43 : $rand.hashCode());
        return result;
    }

    public String debugName() {
        return "evilcraft:broom";
    }
}

