/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.degradation.effect;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import org.cyclops.cyclopscore.helper.EntityHelpers;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.evilcraft.api.degradation.IDegradable;
import org.cyclops.evilcraft.core.config.extendedconfig.DegradationEffectConfig;
import org.cyclops.evilcraft.core.degradation.StochasticDegradationEffect;

public class MobSpawnDegradation
extends StochasticDegradationEffect {
    private static final double CHANCE = 0.01;

    public MobSpawnDegradation(DegradationEffectConfig eConfig) {
        super(eConfig, 0.01);
    }

    @Override
    public void runClientSide(IDegradable degradable) {
    }

    @Override
    public void runServerSide(IDegradable degradable) {
        Mob entityliving;
        ServerLevel world = (ServerLevel)degradable.getDegradationWorld();
        BlockPos spawn = IModHelpers.get().getLocationHelpers().getRandomPointInSphere(degradable.getLocation(), degradable.getRadius());
        float x = (float)spawn.getX() + 0.5f;
        float y = spawn.getY();
        float z = (float)spawn.getZ() + 0.5f;
        Optional spawnlistentry = ((Biome)world.getBiome(spawn).value()).getMobSettings().getMobs(MobCategory.MONSTER).getRandom(world.random);
        try {
            entityliving = (Mob)((MobSpawnSettings.SpawnerData)spawnlistentry.get()).type().create(world, null, spawn, EntitySpawnReason.MOB_SUMMONED, false, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        EntityHelpers.spawnEntity((ServerLevelAccessor)world, (Mob)entityliving, (EntitySpawnReason)EntitySpawnReason.MOB_SUMMONED);
    }
}

