/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.fluid;

import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.capability.fluid.FluidHandlerItemCapacity;

public class FluidContainerItemWrapperWithSimulation
extends FluidHandlerItemCapacity {
    public FluidContainerItemWrapperWithSimulation(ItemStack container, int capacity) {
        super(container, capacity);
    }

    public FluidContainerItemWrapperWithSimulation(ItemStack container, int capacity, Fluid fluid) {
        super(container, capacity, fluid);
    }

    protected IFluidHandler.FluidAction shouldDoFill(FluidStack resource, IFluidHandler.FluidAction doFill) {
        if (doFill.simulate()) {
            return IFluidHandler.FluidAction.SIMULATE;
        }
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        if ("net.neoforged.neoforge.fluids.FluidUtil".equals(stackTraceElements[3].getClassName()) && "lambda$tryFillContainer$1".equals(stackTraceElements[3].getMethodName())) {
            doFill = IFluidHandler.FluidAction.SIMULATE;
        }
        return doFill;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
        doFill = this.shouldDoFill(resource, doFill);
        return super.fill(resource, doFill);
    }

    protected FluidStack wrapSimulatedDrained(FluidStack drained, IFluidHandler.FluidAction doDrain) {
        if (doDrain.execute() || drained.isEmpty() || drained.getAmount() == 0) {
            return drained;
        }
        return FluidContainerItemWrapperWithSimulation.asSimulatedFluidStack(new FluidStack(drained.getFluid(), drained.getAmount()));
    }

    public static FluidStack asSimulatedFluidStack(FluidStack fluidStack) {
        return fluidStack;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
        FluidStack drained = super.drain(maxDrain, doDrain);
        return this.wrapSimulatedDrained(drained, doDrain);
    }

    protected IFluidHandler.FluidAction shouldDoDrain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
        if (doDrain.simulate()) {
            return IFluidHandler.FluidAction.SIMULATE;
        }
        return doDrain;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
        doDrain = this.shouldDoDrain(resource, doDrain);
        return this.wrapSimulatedDrained(super.drain(resource, doDrain), doDrain);
    }
}

