/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.item;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;
import org.cyclops.cyclopscore.item.DamageIndicatedItemFluidContainer;
import org.cyclops.evilcraft.RegistryEntries;

public class ItemBloodContainer
extends DamageIndicatedItemFluidContainer {
    protected boolean canPickUp = true;
    private boolean placeFluids = false;

    public ItemBloodContainer(Item.Properties builder, int capacity) {
        super(builder, capacity, () -> RegistryEntries.FLUID_BLOOD.get());
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        IFluidHandlerItemCapacity fluidHandler = IModHelpersNeoForge.get().getFluidHelpers().getFluidHandlerItemCapacity(itemStack).orElse(null);
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)itemStack).orElse(FluidStack.EMPTY);
        FluidStack drained = fluidHandler.drain(IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume(), IFluidHandler.FluidAction.SIMULATE);
        boolean hasBucket = !drained.isEmpty() && drained.getAmount() == IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume();
        boolean hasSpace = fluidStack.isEmpty() || fluidStack.getAmount() + IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume() <= fluidHandler.getCapacity();
        BlockHitResult movingobjectpositionDrain = ItemBloodContainer.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        BlockHitResult movingobjectpositionFill = ItemBloodContainer.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (movingobjectpositionDrain != null && movingobjectpositionFill != null) {
            BlockPos blockPos;
            BlockState blockState;
            if (this.isPickupFluids() && movingobjectpositionFill.getType() == HitResult.Type.BLOCK && (blockState = world.getBlockState(blockPos = movingobjectpositionFill.getBlockPos())).getBlock() instanceof LiquidBlock && ((LiquidBlock)blockState.getBlock()).fluid == this.getFluid() && (Integer)blockState.getValue((Property)LiquidBlock.LEVEL) == 0) {
                if (hasSpace) {
                    world.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 3);
                    fluidHandler.fill(new FluidStack(this.getFluid(), IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume()), IFluidHandler.FluidAction.EXECUTE);
                }
                return InteractionResult.SUCCESS.heldItemTransformedTo(itemStack);
            }
            if (hasBucket && this.isPlaceFluids() && movingobjectpositionDrain.getType() == HitResult.Type.BLOCK) {
                blockPos = movingobjectpositionFill.getBlockPos();
                Direction direction = movingobjectpositionDrain.getDirection();
                if (this.tryPlaceContainedLiquid(world, blockPos = blockPos.offset(direction.getUnitVec3i()), true)) {
                    fluidHandler.drain(IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume(), IFluidHandler.FluidAction.EXECUTE);
                    return InteractionResult.SUCCESS.heldItemTransformedTo(itemStack);
                }
            }
        }
        return InteractionResult.SUCCESS.heldItemTransformedTo(itemStack);
    }

    private boolean tryPlaceContainedLiquid(Level world, BlockPos blockPos, boolean hasBucket) {
        if (!hasBucket) {
            return false;
        }
        BlockState blockState = world.getBlockState(blockPos);
        if (!world.isEmptyBlock(blockPos) && blockState.isSolid()) {
            return false;
        }
        if (!(world.isClientSide || blockState.isSolid() || blockState.liquid())) {
            world.destroyBlock(blockPos, true);
        }
        world.setBlock(blockPos, this.getFluid().getFluidType().getBlockForFluidState((BlockAndTintGetter)world, blockPos, this.getFluid().defaultFluidState()), 3);
        return true;
    }

    public boolean isPlaceFluids() {
        return this.placeFluids;
    }

    public boolean isPickupFluids() {
        return this.canPickUp;
    }

    public void setPlaceFluids(boolean placeFluids) {
        this.placeFluids = placeFluids;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return InteractionResult.PASS;
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return true;
    }

    protected FluidStack drainFromOthers(int amount, ItemStack itemStack, Fluid fluid, Player player, IFluidHandler.FluidAction action) {
        PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
        FluidStack drained = FluidStack.EMPTY;
        while (it.hasNext() && amount > 0) {
            FluidStack thisDrained;
            FluidStack totalFluid;
            ItemStack current = it.next();
            IFluidHandler containerItem = FluidUtil.getFluidHandler((ItemStack)current).orElse(null);
            if (current.isEmpty() || current == itemStack || containerItem == null || (totalFluid = FluidUtil.getFluidContained((ItemStack)current).orElse(FluidStack.EMPTY)).isEmpty() || totalFluid.getFluid() != fluid || (thisDrained = containerItem.drain(amount, action)).isEmpty() || thisDrained.getFluid() != fluid) continue;
            if (drained.isEmpty()) {
                drained = thisDrained;
            } else {
                drained.setAmount(drained.getAmount() + thisDrained.getAmount());
            }
            amount -= drained.getAmount();
        }
        if (!drained.isEmpty() && drained.isEmpty()) {
            drained = FluidStack.EMPTY;
        }
        return drained;
    }

    public boolean canConsume(int amount, ItemStack itemStack, @Nullable Player player) {
        if (this.canDrain(amount, itemStack)) {
            return true;
        }
        int availableAmount = FluidUtil.getFluidContained((ItemStack)itemStack).map(FluidStack::getAmount).orElse(0);
        return player != null && !this.drainFromOthers(amount - availableAmount, itemStack, this.getFluid(), player, IFluidHandler.FluidAction.SIMULATE).isEmpty();
    }

    public FluidStack consume(int amount, ItemStack itemStack, @Nullable Player player) {
        FluidStack otherDrained;
        IFluidHandler.FluidAction fluidAction;
        IFluidHandler.FluidAction fluidAction2 = fluidAction = player == null || !player.isCreative() && !player.level().isClientSide ? IFluidHandler.FluidAction.EXECUTE : IFluidHandler.FluidAction.SIMULATE;
        if (amount == 0) {
            return FluidStack.EMPTY;
        }
        FluidStack drained = ((IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)itemStack).orElseGet(null)).drain(amount, fluidAction);
        if (!drained.isEmpty() && drained.getAmount() == amount) {
            return drained;
        }
        int drainedAmount = drained.getAmount();
        int toDrain = amount - drainedAmount;
        FluidStack fluidStack = otherDrained = player == null ? FluidStack.EMPTY : this.drainFromOthers(toDrain, itemStack, this.getFluid(), player, fluidAction);
        if (otherDrained.isEmpty()) {
            return drained;
        }
        otherDrained.setAmount(otherDrained.getAmount() + drainedAmount);
        return otherDrained;
    }
}

