/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.bedframe.geyser;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lol.sylvie.bedframe.geyser.Translator;
import lol.sylvie.bedframe.util.BedframeConstants;
import lol.sylvie.bedframe.util.PathHelper;
import lol.sylvie.bedframe.util.ResourceHelper;
import lol.sylvie.bedframe.util.TranslationHelper;
import lol.sylvie.bedframe.util.ZipHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.Version;
import net.minecraft.class_2561;
import net.minecraft.class_3545;
import team.unnamed.creative.ResourcePack;

public class PackGenerator {
    private static final HashMap<String, ResourcePack> RESOURCE_PACK_MAP = new HashMap();
    public static boolean TRANSLATE_OPTIONAL_ITEMS_HACK = false;

    private static JsonArray getVersionArray() {
        Version version = BedframeConstants.METADATA.getVersion();
        List<Integer> friendly = Arrays.stream(version.getFriendlyString().split("\\.")).map(x -> x.replaceAll("[^0-9]", "")).map(Integer::valueOf).toList();
        JsonArray array = new JsonArray(friendly.size());
        friendly.forEach(arg_0 -> ((JsonArray)array).add(arg_0));
        return array;
    }

    private static void writeJsonToFile(JsonElement object, File file) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            BedframeConstants.GSON.toJson(object, (Appendable)writer);
        }
    }

    private static String getUuidString(String base) {
        return UUID.nameUUIDFromBytes(base.getBytes()).toString();
    }

    private static void writeManifestFile(Path directory) throws IOException {
        String versionIdentifier = BedframeConstants.METADATA.getId() + "-" + BedframeConstants.METADATA.getVersion().getFriendlyString();
        boolean shouldRandomize = FabricLoader.getInstance().isDevelopmentEnvironment();
        File manifestFile = directory.resolve("manifest.json").toFile();
        JsonObject manifestObject = new JsonObject();
        manifestObject.addProperty("format_version", (Number)2);
        JsonArray version = PackGenerator.getVersionArray();
        JsonObject header = new JsonObject();
        header.addProperty("description", BedframeConstants.METADATA.getDescription());
        header.addProperty("name", BedframeConstants.METADATA.getId());
        header.addProperty("uuid", shouldRandomize ? UUID.randomUUID().toString() : PackGenerator.getUuidString(versionIdentifier));
        header.add("version", (JsonElement)version);
        JsonArray engineVersion = new JsonArray();
        engineVersion.add((Number)1);
        engineVersion.add((Number)21);
        engineVersion.add((Number)70);
        header.add("min_engine_version", (JsonElement)engineVersion);
        manifestObject.add("header", (JsonElement)header);
        JsonArray modules = new JsonArray();
        JsonObject module = new JsonObject();
        module.addProperty("description", BedframeConstants.METADATA.getName() + " Resources");
        module.addProperty("type", "resources");
        module.addProperty("uuid", shouldRandomize ? UUID.randomUUID().toString() : PackGenerator.getUuidString(versionIdentifier + "-resources"));
        module.add("version", (JsonElement)version);
        modules.add((JsonElement)module);
        manifestObject.add("modules", (JsonElement)modules);
        PackGenerator.writeJsonToFile((JsonElement)manifestObject, manifestFile);
    }

    public void generatePack(Path packPath, File outputFile, List<Translator> translators) throws IOException {
        PackGenerator.writeManifestFile(packPath);
        Path textsDir = packPath.resolve("texts");
        PathHelper.createDirectoryOrThrow(textsDir);
        JsonArray languages = new JsonArray();
        ArrayList allKeys = new ArrayList();
        translators.forEach(t -> allKeys.addAll(t.getTranslations()));
        TranslationHelper.LANGUAGES.forEach(code -> {
            try (FileWriter writer = new FileWriter(textsDir.resolve(code + ".lang").toFile());){
                for (class_3545 keyPair : allKeys) {
                    writer.write((String)keyPair.method_15442() + "=" + class_2561.method_43471((String)((String)keyPair.method_15441())).getString() + "\n");
                }
            }
            catch (IOException e) {
                BedframeConstants.LOGGER.error("Couldn't write language file");
            }
            languages.add(code);
        });
        PackGenerator.writeJsonToFile((JsonElement)languages, textsDir.resolve("languages.json").toFile());
        Optional icon = BedframeConstants.METADATA.getIconPath(512);
        Files.copy(ResourceHelper.getResource((String)icon.orElseThrow()), packPath.resolve("pack_icon.png"), new CopyOption[0]);
        ZipHelper.zipFolder(packPath, outputFile);
    }
}

